/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.id;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOReference;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOIDReference
implements CDOReference<CDOID> {
    private CDOID targetID;
    private CDOID sourceID;
    private EReference sourceReference;
    private int sourceIndex;

    public CDOIDReference(CDOID targetID, CDOID sourceID, EStructuralFeature sourceReference, int sourceIndex) {
        this.targetID = targetID;
        this.sourceID = sourceID;
        this.sourceReference = (EReference)sourceReference;
        this.sourceIndex = sourceIndex;
    }

    public CDOIDReference(CDODataInput in) throws IOException {
        this.targetID = in.readCDOID();
        this.sourceID = in.readCDOID();
        EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
        String featureName = in.readString();
        this.sourceReference = (EReference)eClass.getEStructuralFeature(featureName);
        this.sourceIndex = in.readXInt();
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOID(this.targetID);
        out.writeCDOID(this.sourceID);
        out.writeCDOClassifierRef((EClassifier)this.sourceReference.getEContainingClass());
        out.writeString(this.sourceReference.getName());
        out.writeXInt(this.sourceIndex);
    }

    @Override
    public CDOID getTargetObject() {
        return this.targetID;
    }

    @Override
    public CDOID getSourceObject() {
        return this.sourceID;
    }

    @Override
    @Deprecated
    public EStructuralFeature getSourceFeature() {
        return this.sourceReference;
    }

    @Override
    public EReference getSourceReference() {
        return this.sourceReference;
    }

    @Override
    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.sourceID);
        builder.append(".");
        builder.append(this.sourceReference.getName());
        if (this.sourceIndex != -1) {
            builder.append("[");
            builder.append(this.sourceIndex);
            builder.append("]");
        }
        builder.append(" --> ");
        builder.append(this.targetID);
        return builder.toString();
    }
}

