/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultMethodDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodOrdererContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.LruCache;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class MethodOrderingVisitor
extends AbstractOrderingVisitor {
    private final LruCache<ClassBasedTestDescriptor, AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor>> ordererCache = new LruCache(10);
    private final JupiterConfiguration configuration;
    private final AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> globalOrderer;
    private final DiscoveryIssueReporter.Condition<MethodBasedTestDescriptor> noOrderAnnotation;
    private final UnaryOperator<List<TestDescriptor>> methodsBeforeNestedClassesOrderer;

    MethodOrderingVisitor(JupiterConfiguration configuration, DiscoveryIssueReporter issueReporter) {
        super(issueReporter);
        this.configuration = configuration;
        this.globalOrderer = this.createGlobalOrderer(configuration);
        this.noOrderAnnotation = issueReporter.createReportingCondition(testDescriptor -> !AnnotationSupport.isAnnotated((AnnotatedElement)testDescriptor.getTestMethod(), Order.class), testDescriptor -> {
            String message = "Ineffective @Order annotation on method '%s'. It will not be applied because MethodOrderer.OrderAnnotation is not in use. Note that the annotation may be either directly present or meta-present on the method.".formatted(testDescriptor.getTestMethod().toGenericString());
            return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.INFO, (String)message).source(testDescriptor.getSource()).build();
        });
        this.methodsBeforeNestedClassesOrderer = MethodOrderingVisitor.createMethodsBeforeNestedClassesOrderer();
    }

    public void visit(TestDescriptor testDescriptor) {
        this.doWithMatchingDescriptor(ClassBasedTestDescriptor.class, testDescriptor, this::orderContainedMethods, descriptor -> "Failed to order methods for " + String.valueOf(descriptor.getTestClass()));
    }

    @Override
    protected boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes() {
        return false;
    }

    private void orderContainedMethods(ClassBasedTestDescriptor descriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> wrapperOrderer = this.createAndCacheClassLevelOrderer(descriptor);
        MethodOrderer methodOrderer = wrapperOrderer.getOrderer();
        this.orderChildrenTestDescriptors(descriptor, MethodBasedTestDescriptor.class, this.toValidationAction(methodOrderer), DefaultMethodDescriptor::new, wrapperOrderer);
        if (methodOrderer == null) {
            descriptor.orderChildren(this.methodsBeforeNestedClassesOrderer);
        } else {
            methodOrderer.getDefaultExecutionMode().map(JupiterTestDescriptor::toExecutionMode).ifPresent(descriptor::setDefaultChildExecutionMode);
        }
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> createGlobalOrderer(JupiterConfiguration configuration) {
        MethodOrderer methodOrderer = configuration.getDefaultTestMethodOrderer().orElse(null);
        return methodOrderer == null ? AbstractOrderingVisitor.DescriptorWrapperOrderer.noop() : this.createDescriptorWrapperOrderer(methodOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> createAndCacheClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> orderer = this.createClassLevelOrderer(classBasedTestDescriptor);
        this.ordererCache.put((Object)classBasedTestDescriptor, orderer);
        return orderer;
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> createClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        return AnnotationSupport.findAnnotation(classBasedTestDescriptor.getTestClass(), TestMethodOrder.class).map(TestMethodOrder::value).map(this::createDescriptorWrapperOrderer).orElseGet(() -> {
            Object parent = classBasedTestDescriptor.getParent().orElse(null);
            if (parent instanceof ClassBasedTestDescriptor) {
                ClassBasedTestDescriptor parentClassTestDescriptor = parent;
                AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> cacheEntry = (AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor>)this.ordererCache.get((Object)parentClassTestDescriptor);
                return cacheEntry != null ? cacheEntry : this.createClassLevelOrderer(parentClassTestDescriptor);
            }
            return this.globalOrderer;
        });
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> createDescriptorWrapperOrderer(Class<? extends MethodOrderer> ordererClass) {
        if (ordererClass == MethodOrderer.Default.class) {
            return this.globalOrderer;
        }
        return this.createDescriptorWrapperOrderer((MethodOrderer)ReflectionSupport.newInstance(ordererClass, (Object[])new Object[0]));
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor> createDescriptorWrapperOrderer(MethodOrderer methodOrderer) {
        AbstractOrderingVisitor.OrderingAction orderingAction = (parent, methodDescriptors) -> methodOrderer.orderMethods((MethodOrdererContext)new DefaultMethodOrdererContext(parent.getTestClass(), methodDescriptors, this.configuration));
        AbstractOrderingVisitor.MessageGenerator<ClassBasedTestDescriptor> descriptorsAddedMessageGenerator = (parent, number) -> "MethodOrderer [%s] added %d MethodDescriptor(s) for test class [%s] which will be ignored.".formatted(methodOrderer.getClass().getName(), number, parent.getTestClass().getName());
        AbstractOrderingVisitor.MessageGenerator<ClassBasedTestDescriptor> descriptorsRemovedMessageGenerator = (parent, number) -> "MethodOrderer [%s] removed %d MethodDescriptor(s) for test class [%s] which will be retained with arbitrary ordering.".formatted(methodOrderer.getClass().getName(), number, parent.getTestClass().getName());
        return new AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassBasedTestDescriptor, MethodOrderer, DefaultMethodDescriptor>(methodOrderer, orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
    }

    private Optional<Consumer<MethodBasedTestDescriptor>> toValidationAction(@Nullable MethodOrderer methodOrderer) {
        if (methodOrderer instanceof MethodOrderer.OrderAnnotation) {
            return Optional.empty();
        }
        return Optional.of(arg_0 -> this.noOrderAnnotation.check(arg_0));
    }

    private static UnaryOperator<List<TestDescriptor>> createMethodsBeforeNestedClassesOrderer() {
        Comparator<Object> methodsFirst = Comparator.comparing(MethodBasedTestDescriptor.class::isInstance).reversed();
        return children -> {
            children.sort(methodsFirst);
            return children;
        };
    }
}

