/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AmbiguateProperties;
import com.google.javascript.jscomp.AngularPass;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.ChainCalls;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckEventfulObjectDisposal;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.ClosureOptimizePrimitives;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ConstParamCheck;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CoverageInstrumentationPass;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossModuleCodeMotion;
import com.google.javascript.jscomp.CrossModuleMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DartSuperAccessorsPass;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.DeclaredGlobalExternsOnWindow;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizePrototypeMethods;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguatePrivateProperties;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.Es6ExternsCheck;
import com.google.javascript.jscomp.Es6ToEs3ClassSideInheritance;
import com.google.javascript.jscomp.Es6TypedToEs6Converter;
import com.google.javascript.jscomp.ExpandJqueryAliases;
import com.google.javascript.jscomp.ExploitAssigns;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherExternProperties;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.InferConsts;
import com.google.javascript.jscomp.InjectEs6RuntimeLibrary;
import com.google.javascript.jscomp.InlineAliases;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineObjectLiterals;
import com.google.javascript.jscomp.InlineProperties;
import com.google.javascript.jscomp.InlineSimpleMethods;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.InstrumentFunctions;
import com.google.javascript.jscomp.J2clPass;
import com.google.javascript.jscomp.J2clPropertyInlinerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsdocToEs6TypedConverter;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkNoSideEffectCalls;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.MoveFunctionDeclarations;
import com.google.javascript.jscomp.NameAnalyzer;
import com.google.javascript.jscomp.NameAnonymousFunctions;
import com.google.javascript.jscomp.NameAnonymousFunctionsMapped;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NameReferenceGraphReport;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ObjectLitAssignmentShortening;
import com.google.javascript.jscomp.ObjectPropertyStringPostprocess;
import com.google.javascript.jscomp.ObjectPropertyStringPreprocess;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveUnusedClassProperties;
import com.google.javascript.jscomp.RemoveUnusedPrototypeProperties;
import com.google.javascript.jscomp.RemoveUnusedVars;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenameProperties;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.RenamingMap;
import com.google.javascript.jscomp.ReorderConstantExpression;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceMessagesForChrome;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RescopeGlobalSymbols;
import com.google.javascript.jscomp.RewriteBindThis;
import com.google.javascript.jscomp.RuntimeTypeCheck;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.StatementFusion;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.SubstituteEs6Syntax;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckForInOverArray;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckNullableReturn;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class DefaultPassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    static final DiagnosticType CANNOT_USE_PROTOTYPE_AND_VAR = DiagnosticType.error("JSC_CANNOT_USE_PROTOTYPE_AND_VAR", "Rename prototypes and inline variables cannot be used together.");
    private static final DiagnosticType NAME_REF_GRAPH_FILE_ERROR = DiagnosticType.error("JSC_NAME_REF_GRAPH_FILE_ERROR", "Error \"{1}\" writing name reference graph to \"{0}\".");
    private static final DiagnosticType NAME_REF_REPORT_FILE_ERROR = DiagnosticType.error("JSC_NAME_REF_REPORT_FILE_ERROR", "Error \"{1}\" writing name reference report to \"{0}\".");
    private static final Pattern GLOBAL_SYMBOL_NAMESPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9$_]+$");
    private GlobalNamespace namespaceForChecks = null;
    private PreprocessorSymbolTable preprocessorSymbolTable = null;
    private Set<String> exportedNames = null;
    private CrossModuleMethodMotion.IdGenerator crossModuleIdGenerator = new CrossModuleMethodMotion.IdGenerator();
    private Map<String, Integer> cssNames = null;
    private VariableMap variableMap = null;
    private VariableMap propertyMap = null;
    private VariableMap anonymousFunctionNameMap = null;
    private FunctionNames functionNames = null;
    private VariableMap stringMap = null;
    private String idGeneratorMap = null;
    private final boolean protectHiddenSideEffects;
    private final PassFactory.HotSwapPassFactory checkSideEffects = new PassFactory.HotSwapPassFactory("checkSideEffects", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckSideEffects(compiler, DefaultPassConfig.this.options.checkSuspiciousCode, DefaultPassConfig.this.protectHiddenSideEffects);
        }
    };
    private final PassFactory stripSideEffectProtection = new PassFactory("stripSideEffectProtection", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckSideEffects.StripProtection(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory suspiciousCode = new PassFactory.HotSwapPassFactory("suspiciousCode", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ArrayList<NodeTraversal.Callback> sharedCallbacks = new ArrayList<NodeTraversal.Callback>();
            if (DefaultPassConfig.this.options.checkSuspiciousCode) {
                sharedCallbacks.add(new CheckSuspiciousCode());
                sharedCallbacks.add(new CheckDuplicateCase(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.GLOBAL_THIS)) {
                sharedCallbacks.add(new CheckGlobalThis(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
                sharedCallbacks.add(new CheckDebuggerStatement(compiler));
            }
            return DefaultPassConfig.combineChecks(compiler, sharedCallbacks);
        }
    };
    private final PassFactory.HotSwapPassFactory checkRequires = new PassFactory.HotSwapPassFactory("checkRequires", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckRequiresForConstructors(compiler, CheckRequiresForConstructors.Mode.FULL_COMPILE);
        }
    };
    private final PassFactory.HotSwapPassFactory checkProvides = new PassFactory.HotSwapPassFactory("checkProvides", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckProvides(compiler);
        }
    };
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error("JSC_GENERATE_EXPORTS_ERROR", "Exports can only be generated if export symbol/property functions are set.");
    private final PassFactory.HotSwapPassFactory checkJsDoc = new PassFactory.HotSwapPassFactory("checkJsDoc", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckJSDoc(compiler);
        }
    };
    private final PassFactory generateExports = new PassFactory("generateExports", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null && convention.getExportPropertyFunction() != null) {
                final GenerateExports pass = new GenerateExports(compiler, DefaultPassConfig.this.options.exportLocalPropertyDefinitions, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
                return new CompilerPass(){

                    @Override
                    public void process(Node externs, Node root) {
                        pass.process(externs, root);
                        if (DefaultPassConfig.this.exportedNames == null) {
                            DefaultPassConfig.this.exportedNames = new HashSet();
                        }
                        DefaultPassConfig.this.exportedNames.addAll(pass.getExportedVariableNames());
                    }
                };
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }
    };
    private final PassFactory exportTestFunctions = new PassFactory("exportTestFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null) {
                return new ExportTestFunctions(compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }
    };
    private final PassFactory gatherRawExports = new PassFactory("gatherRawExports", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            final GatherRawExports pass = new GatherRawExports(compiler);
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    if (DefaultPassConfig.this.exportedNames == null) {
                        DefaultPassConfig.this.exportedNames = new HashSet();
                    }
                    DefaultPassConfig.this.exportedNames.addAll(pass.getExportedVariableNames());
                }
            };
        }
    };
    private final PassFactory.HotSwapPassFactory closurePrimitives = new PassFactory.HotSwapPassFactory("closurePrimitives", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            DefaultPassConfig.this.maybeInitializePreprocessorSymbolTable(compiler);
            final ProcessClosurePrimitives pass = new ProcessClosurePrimitives(compiler, DefaultPassConfig.this.preprocessorSymbolTable, DefaultPassConfig.this.options.brokenClosureRequiresLevel, DefaultPassConfig.this.options.preserveGoogRequires);
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    DefaultPassConfig.this.exportedNames = pass.getExportedVariableNames();
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    pass.hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }
    };
    private final PassFactory jqueryAliases = new PassFactory("jqueryAliases", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ExpandJqueryAliases(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory angularPass = new PassFactory.HotSwapPassFactory("angularPass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new AngularPass(compiler);
        }
    };
    private final PassFactory replaceMessages = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ReplaceMessages(compiler, DefaultPassConfig.this.options.messageBundle, true, JsMessage.Style.CLOSURE, false);
        }
    };
    private final PassFactory replaceMessagesForChrome = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ReplaceMessagesForChrome(compiler, new GoogleJsMessageIdGenerator(DefaultPassConfig.this.options.tcProjectId), true, JsMessage.Style.CLOSURE);
        }
    };
    private final PassFactory.HotSwapPassFactory closureGoogScopeAliases = new PassFactory.HotSwapPassFactory("closureGoogScopeAliases", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            DefaultPassConfig.this.maybeInitializePreprocessorSymbolTable(compiler);
            return new ScopedAliases(compiler, DefaultPassConfig.this.preprocessorSymbolTable, DefaultPassConfig.this.options.getAliasTransformationHandler());
        }
    };
    private final PassFactory es6RuntimeLibrary = new PassFactory("Es6RuntimeLibrary", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InjectEs6RuntimeLibrary(compiler);
        }
    };
    private final PassFactory es6ExternsCheck = new PassFactory("es6ExternsCheck", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6ExternsCheck(compiler);
        }
    };
    final PassFactory.HotSwapPassFactory convertEs6TypedToEs6 = new PassFactory.HotSwapPassFactory("convertEs6Typed", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6TypedToEs6Converter(compiler);
        }
    };
    private final PassFactory convertStaticInheritance = new PassFactory("Es6StaticInheritance", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6ToEs3ClassSideInheritance(compiler);
        }
    };
    private final PassFactory inlineTypeAliases = new PassFactory("inlineTypeAliases", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineAliases(compiler);
        }
    };
    private final PassFactory convertToTypedES6 = new PassFactory("ConvertToTypedES6", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new JsdocToEs6TypedConverter(compiler);
        }
    };
    private final PassFactory markTranspilationDone = new PassFactory("setLanguageMode", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    CompilerOptions.LanguageMode langOut = DefaultPassConfig.this.options.getLanguageOut();
                    compiler.setLanguageMode(langOut.isEs6OrHigher() ? CompilerOptions.LanguageMode.ECMASCRIPT5 : langOut);
                }
            };
        }
    };
    private final PassFactory declaredGlobalExternsOnWindow = new PassFactory("declaredGlobalExternsOnWindow", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeclaredGlobalExternsOnWindow(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory closureRewriteClass = new PassFactory.HotSwapPassFactory("closureRewriteClass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory closureCheckModule = new PassFactory.HotSwapPassFactory("closureCheckModule", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureCheckModule(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory closureRewriteModule = new PassFactory.HotSwapPassFactory("closureRewriteModule", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteModule(compiler);
        }
    };
    private final PassFactory closureCheckGetCssName = new PassFactory("closureCheckGetCssName", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingGetCssName(compiler, DefaultPassConfig.this.options.checkMissingGetCssNameLevel, DefaultPassConfig.this.options.checkMissingGetCssNameBlacklist);
        }
    };
    private final PassFactory closureReplaceGetCssName = new PassFactory("closureReplaceGetCssName", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    HashMap<String, Integer> newCssNames = null;
                    if (DefaultPassConfig.this.options.gatherCssNames) {
                        newCssNames = new HashMap<String, Integer>();
                    }
                    ReplaceCssNames pass = new ReplaceCssNames(compiler, newCssNames, DefaultPassConfig.this.options.cssRenamingWhitelist);
                    pass.process(externs, jsRoot);
                    DefaultPassConfig.this.cssNames = newCssNames;
                }
            };
        }
    };
    private final PassFactory createSyntheticBlocks = new PassFactory("createSyntheticBlocks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CreateSyntheticBlocks(compiler, DefaultPassConfig.this.options.syntheticBlockStartMarker, DefaultPassConfig.this.options.syntheticBlockEndMarker);
        }
    };
    private final PassFactory earlyPeepholeOptimizations = new PassFactory("earlyPeepholeOptimizations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new PeepholeOptimizationsPass(compiler, new PeepholeRemoveDeadCode());
        }
    };
    private final PassFactory earlyInlineVariables = new PassFactory("earlyInlineVariables", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (DefaultPassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (DefaultPassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }
    };
    private final PassFactory peepholeOptimizations = new PassFactory("peepholeOptimizations", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            boolean late = false;
            return new PeepholeOptimizationsPass(compiler, new PeepholeMinimizeConditions(false), new PeepholeSubstituteAlternateSyntax(false), new PeepholeReplaceKnownMethods(false), new PeepholeRemoveDeadCode(), new PeepholeFoldConstants(false, DefaultPassConfig.this.options.useTypesForOptimization), new PeepholeCollectPropertyAssignments());
        }
    };
    private final PassFactory latePeepholeOptimizations = new PassFactory("latePeepholeOptimizations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            boolean late = true;
            return new PeepholeOptimizationsPass(compiler, new StatementFusion(DefaultPassConfig.this.options.aggressiveFusion), new PeepholeRemoveDeadCode(), new PeepholeMinimizeConditions(true), new PeepholeSubstituteAlternateSyntax(true), new PeepholeReplaceKnownMethods(true), new PeepholeFoldConstants(true, DefaultPassConfig.this.options.useTypesForOptimization), new ReorderConstantExpression());
        }
    };
    private final PassFactory.HotSwapPassFactory checkVars = new PassFactory.HotSwapPassFactory("checkVars", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VarCheck(compiler);
        }
    };
    private final PassFactory inferConsts = new PassFactory("inferConsts", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InferConsts(compiler);
        }
    };
    private final PassFactory checkRegExp = new PassFactory("checkRegExp", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            final CheckRegExp pass = new CheckRegExp(compiler);
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.setHasRegExpGlobalReferences(pass.isGlobalRegExpPropertiesUsed());
                }
            };
        }
    };
    private final PassFactory.HotSwapPassFactory checkVariableReferences = new PassFactory.HotSwapPassFactory("checkVariableReferences", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler);
        }
    };
    private final PassFactory objectPropertyStringPreprocess = new PassFactory("ObjectPropertyStringPreprocess", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectPropertyStringPreprocess(compiler);
        }
    };
    final PassFactory.HotSwapPassFactory resolveTypes = new PassFactory.HotSwapPassFactory("resolveTypes", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GlobalTypeResolver(compiler);
        }
    };
    private final PassFactory clearTypedScopePass = new PassFactory("clearTypedScopePass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClearTypedScope();
        }
    };
    final PassFactory.HotSwapPassFactory inferTypes = new PassFactory.HotSwapPassFactory("inferTypes", true){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.getTypedScopeCreator());
                    DefaultPassConfig.this.makeTypeInference(compiler).process(externs, root);
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeTypeInference(compiler).inferAllScopes(scriptRoot);
                }
            };
        }
    };
    private final PassFactory symbolTableForNewTypeInference = new PassFactory("GlobalTypeInfo", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return compiler.getSymbolTable();
        }
    };
    private final PassFactory newTypeInference = new PassFactory("NewTypeInference", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new NewTypeInference(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory inferJsDocInfo = new PassFactory.HotSwapPassFactory("inferJsDocInfo", true){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.getTypedScopeCreator());
                    PassConfig.makeInferJsDocInfo(compiler).process(externs, root);
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    PassConfig.makeInferJsDocInfo(compiler).hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }
    };
    private final PassFactory.HotSwapPassFactory checkTypes = new PassFactory.HotSwapPassFactory("checkTypes", true){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.getTypedScopeCreator());
                    TypeCheck check = DefaultPassConfig.this.makeTypeCheck(compiler);
                    check.process(externs, root);
                    compiler.getErrorManager().setTypedPercent(check.getTypedPercent());
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeTypeCheck(compiler).check(scriptRoot, false);
                }
            };
        }
    };
    private final PassFactory.HotSwapPassFactory checkControlFlow = new PassFactory.HotSwapPassFactory("checkControlFlow", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ArrayList<NodeTraversal.ScopedCallback> callbacks = new ArrayList<NodeTraversal.ScopedCallback>();
            if (!DefaultPassConfig.this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE)) {
                callbacks.add(new CheckUnreachableCode(compiler));
            }
            if (!DefaultPassConfig.this.options.getNewTypeInference() && !DefaultPassConfig.this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
                callbacks.add(new CheckMissingReturn(compiler));
            }
            return DefaultPassConfig.combineChecks(compiler, callbacks);
        }
    };
    private final PassFactory.HotSwapPassFactory checkAccessControls = new PassFactory.HotSwapPassFactory("checkAccessControls", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckAccessControls(compiler, DefaultPassConfig.this.options.enforceAccessControlCodingConventions);
        }
    };
    private final PassFactory.HotSwapPassFactory lintChecks = new PassFactory.HotSwapPassFactory("lintChecks", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableList.Builder callbacks = ImmutableList.builder().add((Object)new CheckEmptyStatements(compiler)).add((Object)new CheckEnums(compiler)).add((Object)new CheckInterfaces(compiler)).add((Object)new CheckJSDocStyle(compiler)).add((Object)new CheckPrototypeProperties(compiler)).add((Object)new CheckUnusedPrivateProperties(compiler)).add((Object)new CheckUselessBlocks(compiler));
            return DefaultPassConfig.combineChecks(compiler, (List)callbacks.build());
        }
    };
    private final PassFactory.HotSwapPassFactory analyzerChecks = new PassFactory.HotSwapPassFactory("analyzerChecks", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableList.Builder callbacks = ImmutableList.builder().add((Object)new CheckNullableReturn(compiler)).add((Object)new CheckForInOverArray(compiler)).add((Object)new ImplicitNullabilityCheck(compiler));
            return DefaultPassConfig.combineChecks(compiler, (List)callbacks.build());
        }
    };
    private final PassFactory.HotSwapPassFactory checkRequiresAndProvidesSorted = new PassFactory.HotSwapPassFactory("checkRequiresAndProvidesSorted", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckRequiresAndProvidesSorted(compiler);
        }
    };
    private final PassFactory checkGlobalNames = new PassFactory("checkGlobalNames", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    DefaultPassConfig.this.namespaceForChecks = new GlobalNamespace(compiler, externs, jsRoot);
                    new CheckGlobalNames(compiler, DefaultPassConfig.this.options.checkGlobalNamesLevel).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }
    };
    private final PassFactory checkStrictMode = new PassFactory("checkStrictMode", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new StrictModeCheck(compiler);
        }
    };
    private final PassFactory processTweaks = new PassFactory("processTweaks", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    new ProcessTweaks(compiler, DefaultPassConfig.this.options.getTweakProcessing().shouldStrip(), DefaultPassConfig.this.options.getTweakReplacements()).process(externs, jsRoot);
                }
            };
        }
    };
    private final PassFactory processDefines = new PassFactory("processDefines", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    HashMap<String, Node> replacements = new HashMap<String, Node>();
                    replacements.putAll((Map<String, Node>)compiler.getDefaultDefineValues());
                    replacements.putAll(DefaultPassConfig.getAdditionalReplacements(DefaultPassConfig.this.options));
                    replacements.putAll(DefaultPassConfig.this.options.getDefineReplacements());
                    new ProcessDefines(compiler, (Map<String, Node>)ImmutableMap.copyOf(replacements)).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }
    };
    final PassFactory garbageCollectChecks = new PassFactory.HotSwapPassFactory("garbageCollectChecks", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    DefaultPassConfig.this.namespaceForChecks = null;
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    this.process(null, null);
                }
            };
        }
    };
    private final PassFactory checkConsts = new PassFactory("checkConsts", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConstCheck(compiler);
        }
    };
    private final PassFactory checkConstParams = new PassFactory("checkConstParams", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConstParamCheck(compiler);
        }
    };
    private final PassFactory checkEventfulObjectDisposal = new PassFactory("checkEventfulObjectDisposal", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckEventfulObjectDisposal(compiler, DefaultPassConfig.this.options.checkEventfulObjectDisposalPolicy);
        }
    };
    private final PassFactory computeFunctionNames = new PassFactory("computeFunctionNames", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return DefaultPassConfig.this.functionNames = new FunctionNames(compiler);
        }
    };
    private final PassFactory runtimeTypeCheck = new PassFactory("runtimeTypeCheck", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RuntimeTypeCheck(compiler, DefaultPassConfig.this.options.runtimeTypeCheckLogFunction);
        }
    };
    private final PassFactory replaceIdGenerators = new PassFactory("replaceIdGenerators", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    ReplaceIdGenerators pass = new ReplaceIdGenerators(compiler, (Map<String, RenamingMap>)DefaultPassConfig.this.options.idGenerators, DefaultPassConfig.this.options.generatePseudoNames, DefaultPassConfig.this.options.idGeneratorsMapSerialized);
                    pass.process(externs, root);
                    DefaultPassConfig.this.idGeneratorMap = pass.getSerializedIdMappings();
                }
            };
        }
    };
    private final PassFactory replaceStrings = new PassFactory("replaceStrings", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    ReplaceStrings pass = new ReplaceStrings(compiler, DefaultPassConfig.this.options.replaceStringsPlaceholderToken, DefaultPassConfig.this.options.replaceStringsFunctionDescriptions, DefaultPassConfig.this.options.replaceStringsReservedStrings, DefaultPassConfig.this.options.replaceStringsInputMap);
                    pass.process(externs, root);
                    DefaultPassConfig.this.stringMap = pass.getStringMap();
                }
            };
        }
    };
    private final PassFactory optimizeArgumentsArray = new PassFactory("optimizeArgumentsArray", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new OptimizeArgumentsArray(compiler);
        }
    };
    private final PassFactory closureCodeRemoval = new PassFactory("closureCodeRemoval", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClosureCodeRemoval(compiler, DefaultPassConfig.this.options.removeAbstractMethods, DefaultPassConfig.this.options.removeClosureAsserts);
        }
    };
    private final PassFactory closureOptimizePrimitives = new PassFactory("closureOptimizePrimitives", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClosureOptimizePrimitives(compiler);
        }
    };
    private final PassFactory rescopeGlobalSymbols = new PassFactory("rescopeGlobalSymbols", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RescopeGlobalSymbols(compiler, DefaultPassConfig.this.options.renamePrefixNamespace, DefaultPassConfig.this.options.renamePrefixNamespaceAssumeCrossModuleNames);
        }
    };
    private final PassFactory collapseProperties = new PassFactory("collapseProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseProperties(compiler);
        }
    };
    private final PassFactory collapseObjectLiterals = new PassFactory("collapseObjectLiterals", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineObjectLiterals(compiler, compiler.getUniqueNameIdSupplier());
        }
    };
    private final PassFactory disambiguatePrivateProperties = new PassFactory("disambiguatePrivateProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DisambiguatePrivateProperties(compiler);
        }
    };
    private final PassFactory disambiguateProperties = new PassFactory("disambiguateProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DisambiguateProperties(compiler, DefaultPassConfig.this.options.propertyInvalidationErrors);
        }
    };
    private final PassFactory chainCalls = new PassFactory("chainCalls", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ChainCalls(compiler);
        }
    };
    private final PassFactory devirtualizePrototypeMethods = new PassFactory("devirtualizePrototypeMethods", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DevirtualizePrototypeMethods(compiler);
        }
    };
    private final PassFactory optimizeCalls = new PassFactory("optimizeCalls", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            OptimizeCalls passes = new OptimizeCalls(compiler);
            if (DefaultPassConfig.this.options.optimizeReturns) {
                passes.addPass(new OptimizeReturns(compiler));
            }
            if (DefaultPassConfig.this.options.optimizeParameters) {
                passes.addPass(new OptimizeParameters(compiler));
            }
            return passes;
        }
    };
    private final PassFactory markPureFunctions = new PassFactory("markPureFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new PureFunctionIdentifier.Driver(compiler, DefaultPassConfig.this.options.debugFunctionSideEffectsPath, false);
        }
    };
    private final PassFactory markNoSideEffectCalls = new PassFactory("markNoSideEffectCalls", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new MarkNoSideEffectCalls(compiler);
        }
    };
    private final PassFactory inlineVariables = new PassFactory("inlineVariables", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (DefaultPassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (DefaultPassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }
    };
    private final PassFactory inlineConstants = new PassFactory("inlineConstants", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineVariables(compiler, InlineVariables.Mode.CONSTANTS_ONLY, true);
        }
    };
    private final PassFactory minimizeExitPoints = new PassFactory("minimizeExitPoints", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new MinimizeExitPoints(compiler);
        }
    };
    private final PassFactory removeUnreachableCode = new PassFactory("removeUnreachableCode", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new UnreachableCodeElimination(compiler, true);
        }
    };
    private final PassFactory removeUnusedPrototypeProperties = new PassFactory("removeUnusedPrototypeProperties", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RemoveUnusedPrototypeProperties(compiler, DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns, !DefaultPassConfig.this.options.removeUnusedVars);
        }
    };
    private final PassFactory removeUnusedClassProperties = new PassFactory("removeUnusedClassProperties", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RemoveUnusedClassProperties(compiler, DefaultPassConfig.this.options.removeUnusedConstructorProperties);
        }
    };
    private final PassFactory initNameAnalyzeReport = new PassFactory("initNameAnalyzeReport", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    NameAnalyzer.createEmptyReport(compiler, DefaultPassConfig.this.options.reportPath);
                }
            };
        }
    };
    private final PassFactory extraSmartNamePass = new PassFactory("smartNamePass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new NameAnalyzer(compiler, true, DefaultPassConfig.this.options.reportPath);
        }
    };
    private final PassFactory smartNamePass = new PassFactory("smartNamePass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new NameAnalyzer(compiler, true, DefaultPassConfig.this.options.reportPath);
        }
    };
    private final PassFactory smartNamePass2 = new PassFactory("smartNamePass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new NameAnalyzer(compiler, true, null);
        }
    };
    private final PassFactory inlineSimpleMethods = new PassFactory("inlineSimpleMethods", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineSimpleMethods(compiler);
        }
    };
    private final PassFactory deadAssignmentsElimination = new PassFactory("deadAssignmentsElimination", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeadAssignmentsElimination(compiler);
        }
    };
    private final PassFactory inlineFunctions = new PassFactory("inlineFunctions", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineFunctions(compiler, compiler.getUniqueNameIdSupplier(), DefaultPassConfig.this.options.inlineFunctions, DefaultPassConfig.this.options.inlineLocalFunctions, true, DefaultPassConfig.this.options.assumeStrictThis() || DefaultPassConfig.this.options.getLanguageIn() == CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT, DefaultPassConfig.this.options.assumeClosuresOnlyCaptureReferences, DefaultPassConfig.this.options.maxFunctionSizeAfterInlining);
        }
    };
    private final PassFactory inlineProperties = new PassFactory("inlineProperties", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineProperties(compiler);
        }
    };
    private final PassFactory crossModuleCodeMotion = new PassFactory("crossModuleCodeMotion", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CrossModuleCodeMotion(compiler, compiler.getModuleGraph(), DefaultPassConfig.this.options.parentModuleCanSeeSymbolsDeclaredInChildren);
        }
    };
    private final PassFactory crossModuleMethodMotion = new PassFactory("crossModuleMethodMotion", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CrossModuleMethodMotion(compiler, DefaultPassConfig.this.crossModuleIdGenerator, DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns, DefaultPassConfig.this.options.crossModuleCodeMotionNoStubMethods);
        }
    };
    private final PassFactory flowSensitiveInlineVariables = new PassFactory("flowSensitiveInlineVariables", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new FlowSensitiveInlineVariables(compiler);
        }
    };
    private final PassFactory coalesceVariableNames = new PassFactory("coalesceVariableNames", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CoalesceVariableNames(compiler, DefaultPassConfig.this.options.generatePseudoNames);
        }
    };
    private final PassFactory exploitAssign = new PassFactory("exploitAssign", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new PeepholeOptimizationsPass(compiler, new ExploitAssigns());
        }
    };
    private final PassFactory collapseVariableDeclarations = new PassFactory("collapseVariableDeclarations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseVariableDeclarations(compiler);
        }
    };
    private final PassFactory extractPrototypeMemberDeclarations = new PassFactory("extractPrototypeMemberDeclarations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            ExtractPrototypeMemberDeclarations.Pattern pattern;
            switch (DefaultPassConfig.this.options.extractPrototypeMemberDeclarations) {
                case USE_GLOBAL_TEMP: {
                    pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_GLOBAL_TEMP;
                    break;
                }
                case USE_IIFE: {
                    pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_IIFE;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected");
                }
            }
            return new ExtractPrototypeMemberDeclarations(compiler, pattern);
        }
    };
    private final PassFactory rewriteFunctionExpressions = new PassFactory("rewriteFunctionExpressions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new FunctionRewriter(compiler);
        }
    };
    private final PassFactory collapseAnonymousFunctions = new PassFactory("collapseAnonymousFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseAnonymousFunctions(compiler);
        }
    };
    private final PassFactory moveFunctionDeclarations = new PassFactory("moveFunctionDeclarations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new MoveFunctionDeclarations(compiler);
        }
    };
    private final PassFactory nameUnmappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new NameAnonymousFunctions(compiler);
        }
    };
    private final PassFactory nameMappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    NameAnonymousFunctionsMapped naf = new NameAnonymousFunctionsMapped(compiler, DefaultPassConfig.this.options.inputAnonymousFunctionNamingMap);
                    naf.process(externs, root);
                    DefaultPassConfig.this.anonymousFunctionNameMap = naf.getFunctionMap();
                }
            };
        }
    };
    private final PassFactory aliasStrings = new PassFactory("aliasStrings", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AliasStrings(compiler, compiler.getModuleGraph(), DefaultPassConfig.this.options.aliasAllStrings ? null : DefaultPassConfig.this.options.aliasableStrings, DefaultPassConfig.this.options.aliasStringsBlacklist, DefaultPassConfig.this.options.outputJsStringUsage);
        }
    };
    private final PassFactory objectPropertyStringPostprocess = new PassFactory("ObjectPropertyStringPostprocess", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectPropertyStringPostprocess(compiler);
        }
    };
    private final PassFactory ambiguateProperties = new PassFactory("ambiguateProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AmbiguateProperties(compiler, DefaultPassConfig.this.options.anonymousFunctionNaming.getReservedCharacters());
        }
    };
    private final PassFactory markUnnormalized = new PassFactory("markUnnormalized", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
                }
            };
        }
    };
    private final PassFactory denormalize = new PassFactory("denormalize", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Denormalize(compiler);
        }
    };
    private final PassFactory invertContextualRenaming = new PassFactory("invertContextualRenaming", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return MakeDeclaredNamesUnique.getContextualRenameInverter(compiler);
        }
    };
    private final PassFactory renameProperties = new PassFactory("renameProperties", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            Preconditions.checkState((DefaultPassConfig.this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED ? 1 : 0) != 0);
            final VariableMap prevPropertyMap = DefaultPassConfig.this.options.inputPropertyMap;
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    char[] reservedChars = DefaultPassConfig.this.options.anonymousFunctionNaming.getReservedCharacters();
                    RenameProperties rprop = new RenameProperties(compiler, DefaultPassConfig.this.options.generatePseudoNames, prevPropertyMap, reservedChars, DefaultPassConfig.this.options.nameGenerator);
                    rprop.process(externs, root);
                    DefaultPassConfig.this.propertyMap = rprop.getPropertyMap();
                }
            };
        }
    };
    private final PassFactory renameVars = new PassFactory("renameVars", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            final VariableMap prevVariableMap = DefaultPassConfig.this.options.inputVariableMap;
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    DefaultPassConfig.this.variableMap = DefaultPassConfig.this.runVariableRenaming(compiler, prevVariableMap, externs, root);
                }
            };
        }
    };
    private final PassFactory renameLabels = new PassFactory("renameLabels", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RenameLabels(compiler);
        }
    };
    private final PassFactory convertToDottedProperties = new PassFactory("convertToDottedProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConvertToDottedProperties(compiler);
        }
    };
    private final PassFactory sanityCheckAst = new PassFactory("sanityCheckAst", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AstValidator(compiler);
        }
    };
    private final PassFactory sanityCheckVars = new PassFactory("sanityCheckVars", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new VarCheck(compiler, true);
        }
    };
    private final PassFactory instrumentFunctions = new PassFactory("instrumentFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InstrumentFunctions(compiler, DefaultPassConfig.this.functionNames, DefaultPassConfig.this.options.instrumentationTemplate, DefaultPassConfig.this.options.appNameStr);
        }
    };
    private final PassFactory instrumentForCodeCoverage = new PassFactory("instrumentForCodeCoverage", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CoverageInstrumentationPass(compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL);
        }
    };
    private final PassFactory gatherExternProperties = new PassFactory("gatherExternProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new GatherExternProperties(compiler);
        }
    };
    private final PassFactory printNameReferenceGraph = new PassFactory("printNameReferenceGraph", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    NameReferenceGraphConstruction gc = new NameReferenceGraphConstruction(compiler);
                    gc.process(externs, jsRoot);
                    String graphFileName = DefaultPassConfig.this.options.nameReferenceGraphPath;
                    try {
                        Files.write((CharSequence)DotFormatter.toDot(gc.getNameReferenceGraph()), (File)new File(graphFileName), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        compiler.report(JSError.make(NAME_REF_GRAPH_FILE_ERROR, e.getMessage(), graphFileName));
                    }
                }
            };
        }
    };
    private final PassFactory printNameReferenceReport = new PassFactory("printNameReferenceReport", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    NameReferenceGraphConstruction gc = new NameReferenceGraphConstruction(compiler);
                    String reportFileName = DefaultPassConfig.this.options.nameReferenceReportPath;
                    try {
                        NameReferenceGraphReport report = new NameReferenceGraphReport(gc.getNameReferenceGraph());
                        Files.write((CharSequence)report.getHtmlReport(), (File)new File(reportFileName), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        compiler.report(JSError.make(NAME_REF_REPORT_FILE_ERROR, e.getMessage(), reportFileName));
                    }
                }
            };
        }
    };
    private final PassFactory.HotSwapPassFactory polymerPass = new PassFactory.HotSwapPassFactory("polymerPass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new PolymerPass(compiler);
        }
    };
    private final PassFactory.HotSwapPassFactory dartSuperAccessorsPass = new PassFactory.HotSwapPassFactory("dartSuperAccessorsPass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new DartSuperAccessorsPass(compiler);
        }
    };
    private final PassFactory j2clPass = new PassFactory("j2clPass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clPass(compiler);
        }
    };
    private final PassFactory j2clPropertyInlinerPass = new PassFactory("j2clES6Pass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clPropertyInlinerPass(compiler);
        }
    };
    private final PassFactory checkConformance = new PassFactory("checkConformance", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckConformance(compiler, (ImmutableList<ConformanceConfig>)ImmutableList.copyOf(DefaultPassConfig.this.options.getConformanceConfigs()));
        }
    };
    private final PassFactory optimizeToEs6 = new PassFactory("optimizeToEs6", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new SubstituteEs6Syntax(compiler);
        }
    };
    private final PassFactory objectLitAssignmentShortening = new PassFactory("objectLitAssignmentShortening", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectLitAssignmentShortening(compiler);
        }
    };
    private final PassFactory rewriteBindThis = new PassFactory("rewriteBindThis", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RewriteBindThis(compiler);
        }
    };

    public DefaultPassConfig(CompilerOptions options) {
        super(options);
        this.protectHiddenSideEffects = options != null && options.protectHiddenSideEffects && !options.ideMode;
    }

    @Override
    protected PassConfig.State getIntermediateState() {
        return new PassConfig.State(this.cssNames == null ? null : new HashMap<String, Integer>(this.cssNames), this.exportedNames == null ? null : Collections.unmodifiableSet(this.exportedNames), this.crossModuleIdGenerator, this.variableMap, this.propertyMap, this.anonymousFunctionNameMap, this.stringMap, this.functionNames, this.idGeneratorMap);
    }

    GlobalNamespace getGlobalNamespace() {
        return this.namespaceForChecks;
    }

    PreprocessorSymbolTable getPreprocessorSymbolTable() {
        return this.preprocessorSymbolTable;
    }

    void maybeInitializePreprocessorSymbolTable(AbstractCompiler compiler) {
        if (this.options.ideMode) {
            Node root = compiler.getRoot();
            if (this.preprocessorSymbolTable == null || this.preprocessorSymbolTable.getRootNode() != root) {
                this.preprocessorSymbolTable = new PreprocessorSymbolTable(root);
            }
        }
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = new ArrayList<PassFactory>();
        checks.add(PassFactory.createEmptyPass("beforeStandardChecks"));
        checks.add(this.checkJsDoc);
        if (this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add(this.lintChecks);
        }
        if (!this.options.skipNonTranspilationPasses && this.options.closurePass && this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add(this.checkRequiresAndProvidesSorted);
        }
        if (this.options.closurePass) {
            checks.add(this.closureCheckModule);
            checks.add(this.closureRewriteModule);
        }
        if (!this.options.skipNonTranspilationPasses && this.options.declaredGlobalExternsOnWindow) {
            checks.add(this.declaredGlobalExternsOnWindow);
        }
        if (this.options.getLanguageIn() == CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED && this.options.getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED) {
            checks.add(this.convertEs6TypedToEs6);
        }
        checks.add(this.checkVariableReferences);
        if (!this.options.skipNonTranspilationPasses && this.options.closurePass) {
            checks.add(this.closureGoogScopeAliases);
            checks.add(this.closureRewriteClass);
        }
        if (this.options.enables(DiagnosticGroups.MISSING_REQUIRE) || this.options.enables(DiagnosticGroups.EXTRA_REQUIRE)) {
            checks.add(this.checkRequires);
        }
        checks.add(this.checkSideEffects);
        if (this.options.enables(DiagnosticGroups.MISSING_PROVIDE)) {
            checks.add(this.checkProvides);
        }
        if (this.options.jqueryPass && !this.options.skipNonTranspilationPasses) {
            checks.add(this.jqueryAliases);
        }
        if (this.options.angularPass && !this.options.skipNonTranspilationPasses) {
            checks.add(this.angularPass);
        }
        if (!this.options.generateExportsAfterTypeChecking && this.options.generateExports && !this.options.skipNonTranspilationPasses) {
            checks.add(this.generateExports);
        }
        if (this.options.exportTestFunctions && !this.options.skipNonTranspilationPasses) {
            checks.add(this.exportTestFunctions);
        }
        if (this.options.closurePass && !this.options.skipNonTranspilationPasses) {
            checks.add(this.closurePrimitives);
        }
        if (this.options.polymerPass && !this.options.skipNonTranspilationPasses) {
            checks.add(this.polymerPass);
        }
        if ((this.options.checkSuspiciousCode || this.options.enables(DiagnosticGroups.GLOBAL_THIS) || this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) && !this.options.skipNonTranspilationPasses) {
            checks.add(this.suspiciousCode);
        }
        if (this.options.closurePass && this.options.checkMissingGetCssNameLevel.isOn() && !this.options.skipNonTranspilationPasses) {
            checks.add(this.closureCheckGetCssName);
        }
        if (this.options.syntheticBlockStartMarker != null && !this.options.skipNonTranspilationPasses) {
            checks.add(this.createSyntheticBlocks);
        }
        if (!this.options.skipNonTranspilationPasses) {
            checks.add(this.checkVars);
        }
        if (this.options.inferConsts && !this.options.skipNonTranspilationPasses) {
            checks.add(this.inferConsts);
        }
        if (this.options.computeFunctionSideEffects && !this.options.skipNonTranspilationPasses) {
            checks.add(this.checkRegExp);
        }
        if (this.options.processObjectPropertyString && !this.options.skipNonTranspilationPasses) {
            checks.add(this.objectPropertyStringPreprocess);
        }
        if (this.options.getLanguageIn().isEs6OrHigher() && !this.options.skipTranspilationAndCrash) {
            checks.add(this.es6ExternsCheck);
            TranspilationPasses.addEs6EarlyPasses(checks);
        }
        if (this.options.dartPass && !this.options.getLanguageOut().isEs6OrHigher()) {
            checks.add(this.dartSuperAccessorsPass);
        }
        if (this.options.getLanguageIn().isEs6OrHigher() && !this.options.skipTranspilationAndCrash) {
            TranspilationPasses.addEs6LatePasses(checks);
            checks.add(this.markTranspilationDone);
        }
        if (this.options.raiseToEs6Typed()) {
            checks.add(this.convertToTypedES6);
        }
        if (this.options.getLanguageIn().isEs6OrHigher() && !this.options.skipNonTranspilationPasses || !this.options.forceLibraryInjection.isEmpty()) {
            checks.add(this.es6RuntimeLibrary);
        }
        if (this.options.skipNonTranspilationPasses) {
            return checks;
        }
        checks.add(this.convertStaticInheritance);
        checks.add(PassFactory.createEmptyPass("beforeTypeChecking"));
        if (this.options.getNewTypeInference()) {
            checks.add(this.symbolTableForNewTypeInference);
            checks.add(this.newTypeInference);
        }
        checks.add(this.inlineTypeAliases);
        if (this.options.checkTypes || this.options.inferTypes) {
            checks.add(this.resolveTypes);
            checks.add(this.inferTypes);
            if (this.options.checkTypes) {
                checks.add(this.checkTypes);
            } else {
                checks.add(this.inferJsDocInfo);
            }
            if (!this.options.ideMode) {
                checks.add(this.clearTypedScopePass);
            }
        }
        if (this.options.generateExportsAfterTypeChecking && this.options.generateExports) {
            checks.add(this.generateExports);
        }
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE) || !this.options.getNewTypeInference() && !this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            checks.add(this.checkControlFlow);
        }
        if (this.options.checkTypes && (!this.options.disables(DiagnosticGroups.ACCESS_CONTROLS) || this.options.enables(DiagnosticGroups.CONSTANT_PROPERTY))) {
            checks.add(this.checkAccessControls);
        }
        if (this.options.enables(DiagnosticGroups.ANALYZER_CHECKS)) {
            checks.add(this.analyzerChecks);
        }
        if (this.options.checkEventfulObjectDisposalPolicy != CheckEventfulObjectDisposal.DisposalCheckingPolicy.OFF) {
            checks.add(this.checkEventfulObjectDisposal);
        }
        if (this.options.checkGlobalNamesLevel.isOn()) {
            checks.add(this.checkGlobalNames);
        }
        if (this.options.enables(DiagnosticGroups.ES5_STRICT)) {
            checks.add(this.checkStrictMode);
        }
        if (!this.options.getConformanceConfigs().isEmpty()) {
            checks.add(this.checkConformance);
        }
        if (this.options.closurePass) {
            checks.add(this.closureReplaceGetCssName);
        }
        if (this.options.replaceMessagesWithChromeI18n) {
            checks.add(this.replaceMessagesForChrome);
        } else if (this.options.messageBundle != null) {
            checks.add(this.replaceMessages);
        }
        if (this.options.getTweakProcessing().isOn()) {
            checks.add(this.processTweaks);
        }
        checks.add(this.processDefines);
        if (this.options.instrumentationTemplate != null || this.options.recordFunctionInformation) {
            checks.add(this.computeFunctionNames);
        }
        if (this.options.nameReferenceGraphPath != null && !this.options.nameReferenceGraphPath.isEmpty()) {
            checks.add(this.printNameReferenceGraph);
        }
        if (this.options.nameReferenceReportPath != null && !this.options.nameReferenceReportPath.isEmpty()) {
            checks.add(this.printNameReferenceReport);
        }
        checks.add(PassFactory.createEmptyPass("afterStandardChecks"));
        DefaultPassConfig.assertAllOneTimePasses(checks);
        this.assertValidOrder(checks);
        return checks;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.skipNonTranspilationPasses) {
            return passes;
        }
        passes.add(this.gatherExternProperties);
        passes.add(this.garbageCollectChecks);
        if (this.options.instrumentForCoverage) {
            passes.add(this.instrumentForCodeCoverage);
        }
        if (this.options.runtimeTypeCheck) {
            passes.add(this.runtimeTypeCheck);
        }
        if (this.options.j2clPass) {
            passes.add(this.j2clPass);
            passes.add(this.j2clPropertyInlinerPass);
        }
        passes.add(PassFactory.createEmptyPass("beforeStandardOptimizations"));
        if (this.options.replaceIdGenerators) {
            passes.add(this.replaceIdGenerators);
        }
        if (this.options.optimizeArgumentsArray) {
            passes.add(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            passes.add(this.closureCodeRemoval);
        }
        if (this.options.disambiguatePrivateProperties) {
            passes.add(this.disambiguatePrivateProperties);
        }
        if (this.options.collapseProperties) {
            passes.add(this.collapseProperties);
        }
        if (this.options.inferConsts) {
            passes.add(this.inferConsts);
        }
        if (this.options.reportPath != null && (this.options.extraSmartNameRemoval || this.options.smartNameRemoval)) {
            passes.add(this.initNameAnalyzeReport);
        }
        if (this.options.extraSmartNameRemoval && this.options.smartNameRemoval) {
            if (this.options.foldConstants && (this.options.inlineVariables || this.options.inlineLocalVariables)) {
                passes.add(this.earlyInlineVariables);
                passes.add(this.earlyPeepholeOptimizations);
            }
            passes.add(this.extraSmartNamePass);
        }
        if (this.options.disambiguateProperties) {
            passes.add(this.disambiguateProperties);
        }
        if (this.options.computeFunctionSideEffects) {
            passes.add(this.markPureFunctions);
        } else if (this.options.markNoSideEffectCalls) {
            passes.add(this.markNoSideEffectCalls);
        }
        if (this.options.chainCalls) {
            passes.add(this.chainCalls);
        }
        passes.add(this.checkConsts);
        passes.add(this.checkConstParams);
        DefaultPassConfig.assertAllOneTimePasses(passes);
        if (this.options.smartNameRemoval || this.options.reportPath != null) {
            passes.addAll(this.getCodeRemovingPasses());
            passes.add(this.smartNamePass);
        }
        if (this.options.closurePass) {
            passes.add(this.closureOptimizePrimitives);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            passes.add(this.replaceStrings);
        }
        if (this.options.crossModuleCodeMotion) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.devirtualizePrototypeMethods) {
            passes.add(this.devirtualizePrototypeMethods);
        }
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        passes.add(PassFactory.createEmptyPass("beforeMainOptimizations"));
        if (this.options.flowSensitiveInlineVariables) {
            passes.add(this.flowSensitiveInlineVariables);
        }
        passes.addAll(this.getMainOptimizationLoop());
        passes.add(PassFactory.createEmptyPass("beforeModuleMotion"));
        if (this.options.crossModuleCodeMotion) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.crossModuleMethodMotion) {
            passes.add(this.crossModuleMethodMotion);
        }
        passes.add(PassFactory.createEmptyPass("afterModuleMotion"));
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        if (this.options.flowSensitiveInlineVariables) {
            passes.add(this.flowSensitiveInlineVariables);
            if (this.options.removeUnusedVars || this.options.removeUnusedLocalVars) {
                passes.add(this.getRemoveUnusedVars("removeUnusedVars", false));
            }
        }
        if (this.options.smartNameRemoval) {
            passes.add(this.smartNamePass2);
        }
        if (this.options.collapseAnonymousFunctions) {
            passes.add(this.collapseAnonymousFunctions);
        }
        if (this.options.moveFunctionDeclarations || this.options.renamePrefixNamespace != null) {
            passes.add(this.moveFunctionDeclarations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
            passes.add(this.nameMappedAnonymousFunctions);
        }
        if (this.options.extractPrototypeMemberDeclarations != CompilerOptions.ExtractPrototypeMemberDeclarationsMode.OFF) {
            passes.add(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.ambiguateProperties && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.add(this.ambiguateProperties);
        }
        if (this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.add(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            passes.add(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            passes.add(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            passes.add(this.rewriteFunctionExpressions);
        }
        if (!this.options.aliasableStrings.isEmpty() || this.options.aliasAllStrings) {
            passes.add(this.aliasStrings);
        }
        passes.add(this.markUnnormalized);
        if (this.options.coalesceVariableNames) {
            passes.add(this.coalesceVariableNames);
            if (this.options.foldConstants) {
                passes.add(this.peepholeOptimizations);
            }
        }
        if (this.options.collapseVariableDeclarations) {
            passes.add(this.exploitAssign);
            passes.add(this.collapseVariableDeclarations);
        }
        passes.add(this.denormalize);
        if (this.options.instrumentationTemplate != null) {
            passes.add(this.instrumentFunctions);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            passes.add(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            passes.add(this.renameVars);
        }
        if (this.options.processObjectPropertyString) {
            passes.add(this.objectPropertyStringPostprocess);
        }
        if (this.options.labelRenaming) {
            passes.add(this.renameLabels);
        }
        if (this.options.foldConstants) {
            passes.add(this.latePeepholeOptimizations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
            passes.add(this.nameUnmappedAnonymousFunctions);
        }
        if (this.protectHiddenSideEffects) {
            passes.add(this.stripSideEffectProtection);
        }
        if (this.options.renamePrefixNamespace != null) {
            if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
            }
            passes.add(this.rescopeGlobalSymbols);
        }
        passes.add(this.sanityCheckAst);
        passes.add(this.sanityCheckVars);
        if (this.options.getLanguageOut().isEs6OrHigher()) {
            passes.add(this.optimizeToEs6);
            passes.add(this.objectLitAssignmentShortening);
            passes.add(this.rewriteBindThis);
        }
        return passes;
    }

    private List<PassFactory> getMainOptimizationLoop() {
        boolean runOptimizeCalls;
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.inlineGetters) {
            passes.add(this.inlineSimpleMethods);
        }
        passes.addAll(this.getCodeRemovingPasses());
        if (this.options.inlineFunctions || this.options.inlineLocalFunctions) {
            passes.add(this.inlineFunctions);
        }
        if (this.options.inlineProperties) {
            passes.add(this.inlineProperties);
        }
        boolean bl = runOptimizeCalls = this.options.optimizeCalls || this.options.optimizeParameters || this.options.optimizeReturns;
        if (this.options.removeUnusedVars || this.options.removeUnusedLocalVars) {
            if (this.options.deadAssignmentElimination) {
                passes.add(this.deadAssignmentsElimination);
            }
            if (!runOptimizeCalls) {
                passes.add(this.getRemoveUnusedVars("removeUnusedVars", false));
            }
        }
        if (runOptimizeCalls) {
            passes.add(this.optimizeCalls);
            if (this.options.optimizeCalls) {
                passes.add(this.getRemoveUnusedVars("removeUnusedVars_afterOptimizeCalls", true));
            }
        }
        DefaultPassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private List<PassFactory> getCodeRemovingPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.collapseObjectLiterals) {
            passes.add(this.collapseObjectLiterals);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            passes.add(this.inlineConstants);
        }
        if (this.options.foldConstants) {
            passes.add(this.minimizeExitPoints);
            passes.add(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            passes.add(this.removeUnreachableCode);
        }
        if (this.options.removeUnusedPrototypeProperties) {
            passes.add(this.removeUnusedPrototypeProperties);
        }
        if (this.options.removeUnusedClassProperties) {
            passes.add(this.removeUnusedClassProperties);
        }
        DefaultPassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private static void assertAllOneTimePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState((boolean)pass.isOneTimePass());
        }
    }

    private static void assertAllLoopablePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState((!pass.isOneTimePass() ? 1 : 0) != 0);
        }
    }

    private void assertValidOrder(List<PassFactory> checks) {
        int polymerIndex = checks.indexOf(this.polymerPass);
        int dartSuperAccessorsIndex = checks.indexOf(this.dartSuperAccessorsPass);
        int es6ConvertSuperIndex = checks.indexOf(TranspilationPasses.es6ConvertSuper);
        int closureIndex = checks.indexOf(this.closurePrimitives);
        int suspiciousCodeIndex = checks.indexOf(this.suspiciousCode);
        int checkVarsIndex = checks.indexOf(this.checkVariableReferences);
        int googScopeIndex = checks.indexOf(this.closureGoogScopeAliases);
        if (polymerIndex != -1 && closureIndex != -1) {
            Preconditions.checkState((polymerIndex > closureIndex ? 1 : 0) != 0, (Object)"The Polymer pass must run after goog.provide processing.");
        }
        if (polymerIndex != -1 && suspiciousCodeIndex != -1) {
            Preconditions.checkState((polymerIndex < suspiciousCodeIndex ? 1 : 0) != 0, (Object)"The Polymer pass must run before suspiciousCode processing.");
        }
        if (dartSuperAccessorsIndex != -1 && es6ConvertSuperIndex != -1) {
            Preconditions.checkState((dartSuperAccessorsIndex < es6ConvertSuperIndex ? 1 : 0) != 0, (Object)"The Dart super accessors pass must run before ES6->ES3 super lowering.");
        }
        if (googScopeIndex != -1) {
            Preconditions.checkState((checkVarsIndex != -1 ? 1 : 0) != 0, (Object)"goog.scope processing requires variable checking");
            Preconditions.checkState((checkVarsIndex < googScopeIndex ? 1 : 0) != 0, (Object)"Variable checking must happen before goog.scope processing.");
        }
    }

    private static HotSwapCompilerPass combineChecks(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        Preconditions.checkArgument((!callbacks.isEmpty() ? 1 : 0) != 0);
        return new CombinedCompilerPass(compiler, callbacks);
    }

    private PassFactory getRemoveUnusedVars(String name, final boolean modifyCallSites) {
        return new PassFactory(name, false){

            @Override
            protected CompilerPass create(AbstractCompiler compiler) {
                boolean removeOnlyLocals = DefaultPassConfig.this.options.removeUnusedLocalVars && !DefaultPassConfig.this.options.removeUnusedVars;
                boolean preserveAnonymousFunctionNames = DefaultPassConfig.this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
                return new RemoveUnusedVars(compiler, !removeOnlyLocals, preserveAnonymousFunctionNames, modifyCallSites);
            }
        };
    }

    private VariableMap runVariableRenaming(AbstractCompiler compiler, VariableMap prevVariableMap, Node externs, Node root) {
        char[] reservedChars = this.options.anonymousFunctionNaming.getReservedCharacters();
        boolean preserveAnonymousFunctionNames = this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
        HashSet<String> reservedNames = new HashSet<String>();
        if (this.options.renamePrefixNamespace != null) {
            reservedNames.add(this.options.renamePrefixNamespace);
        }
        if (this.exportedNames != null) {
            reservedNames.addAll(this.exportedNames);
        }
        reservedNames.addAll(ParserRunner.getReservedVars());
        RenameVars rn = new RenameVars(compiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, preserveAnonymousFunctionNames, this.options.generatePseudoNames, this.options.shadowVariables, this.options.preferStableNames, prevVariableMap, reservedChars, reservedNames, this.options.nameGenerator);
        rn.process(externs, root);
        return rn.getVariableMap();
    }

    private PassFactory getCustomPasses(final CustomPassExecutionTime executionTime) {
        return new PassFactory("runCustomPasses", true){

            @Override
            protected CompilerPass create(AbstractCompiler compiler) {
                return DefaultPassConfig.runInSerial(DefaultPassConfig.this.options.customPasses.get((Object)executionTime));
            }
        };
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> passes) {
        return new CompilerPass(){

            @Override
            public void process(Node externs, Node root) {
                for (CompilerPass pass : passes) {
                    pass.process(externs, root);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions options) {
        HashMap<String, Node> additionalReplacements = new HashMap<String, Node>();
        if (options.markAsCompiled || options.closurePass) {
            additionalReplacements.put(COMPILED_CONSTANT_NAME, IR.trueNode());
        }
        if (options.closurePass && options.locale != null) {
            additionalReplacements.put(CLOSURE_LOCALE_CONSTANT_NAME, IR.string(options.locale));
        }
        return additionalReplacements;
    }

    class ClearTypedScope
    implements CompilerPass {
        ClearTypedScope() {
        }

        @Override
        public void process(Node externs, Node root) {
            DefaultPassConfig.this.clearTypedScope();
        }
    }

    class GlobalTypeResolver
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        GlobalTypeResolver(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            if (DefaultPassConfig.this.topScope == null) {
                DefaultPassConfig.this.regenerateGlobalTypedScope(this.compiler, root.getParent());
            } else {
                this.compiler.getTypeRegistry().resolveTypesInScope(DefaultPassConfig.this.topScope);
            }
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            DefaultPassConfig.this.patchGlobalTypedScope(this.compiler, scriptRoot);
        }
    }
}

