/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.Enumeration;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Predicate<T> firstBy(Function<? super T, ?> selector) {
        Ensure.notNull(selector);
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(selector.apply(t), Boolean.TRUE) == null;
    }

    public static <T> Stream<T> toStream(final Enumeration<T> e) {
        Ensure.notNull(e);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!e.hasMoreElements()) {
                    return false;
                }
                action.accept(e.nextElement());
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                }
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

