/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.telnet.connector;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.connector.Logger;
import org.eclipse.terminal.connector.NullSettingsStore;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.terminal.connector.provider.AbstractTerminalConnector;
import org.eclipse.terminal.connector.telnet.connector.ITelnetSettings;
import org.eclipse.terminal.connector.telnet.connector.TelnetConnectWorker;
import org.eclipse.terminal.connector.telnet.connector.TelnetConnection;
import org.eclipse.terminal.connector.telnet.connector.TelnetSettings;

public class TelnetConnector
extends AbstractTerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private Socket fSocket;
    private TelnetConnection fTelnetConnection;
    private final TelnetSettings fSettings;
    private int fWidth = -1;
    private int fHeight = -1;

    public TelnetConnector() {
        this(new TelnetSettings());
    }

    public TelnetConnector(TelnetSettings settings) {
        this.fSettings = settings;
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fWidth = -1;
        this.fHeight = -1;
        control.setVT100LineWrapping(true);
        TelnetConnectWorker worker = new TelnetConnectWorker(this, control);
        worker.start();
    }

    public void doDisconnect() {
        if (this.getSocket() != null) {
            try {
                this.getSocket().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        this.cleanSocket();
    }

    public boolean isLocalEcho() {
        if (this.fTelnetConnection == null) {
            return false;
        }
        return this.fTelnetConnection.localEcho();
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fTelnetConnection != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            this.fTelnetConnection.setTerminalSize(newWidth, newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.fOutputStream = null;
            return;
        }
        this.fOutputStream = new TelnetOutputStream(outputStream, this.fSettings.getEndOfLine());
    }

    Socket getSocket() {
        return this.fSocket;
    }

    void cleanSocket() {
        this.fSocket = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    void setSocket(Socket socket) throws IOException {
        if (socket == null) {
            this.cleanSocket();
        } else {
            this.fSocket = socket;
            this.setInputStream(socket.getInputStream());
            this.setOutputStream(socket.getOutputStream());
        }
    }

    public void setTelnetConnection(TelnetConnection connection) {
        this.fTelnetConnection = connection;
    }

    public void displayTextInTerminal(String text) {
        this.fControl.displayTextInTerminal(text);
    }

    public OutputStream getRemoteToTerminalOutputStream() {
        return this.fControl.getRemoteToTerminalOutputStream();
    }

    public void setState(TerminalState state) {
        this.fControl.setState(state);
    }

    public ITelnetSettings getTelnetSettings() {
        return this.fSettings;
    }

    public void setDefaultSettings() {
        this.fSettings.load((ISettingsStore)new NullSettingsStore());
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    static final class TelnetOutputStream
    extends FilterOutputStream {
        static final byte CR = 13;
        static final byte LF = 10;
        static final byte NUL = 0;
        static final byte[] CRNUL;
        static final byte[] CRLF;
        final byte[] EOL;

        static {
            byte[] byArray = new byte[2];
            byArray[0] = 13;
            CRNUL = byArray;
            CRLF = new byte[]{13, 10};
        }

        public TelnetOutputStream(OutputStream outputStream, String endOfLine) {
            super(outputStream);
            this.EOL = "CR+LF".equals(endOfLine) ? CRLF : CRNUL;
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 13) {
                this.out.write(this.EOL);
            } else {
                this.out.write(b);
            }
        }
    }
}

