/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.java.ui.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.java.ui.InterestUpdateDeltaListener;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.mylyn.internal.java.ui.JavaUiUtil;
import org.eclipse.mylyn.internal.java.ui.LandmarkMarkerManager;
import org.eclipse.mylyn.internal.java.ui.TypeHistoryManager;
import org.eclipse.mylyn.internal.java.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.internal.java.ui.editor.BreakpointEditorTracker;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class JavaUiBridgePlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.java.ui";
    public static final String AUTO_FOLDING_ENABLED = "org.eclipse.mylyn.context.ui.editor.folding.enabled";
    private static JavaUiBridgePlugin INSTANCE;
    private ActiveFoldingEditorTracker editorTracker;
    private TypeHistoryManager typeHistoryManager;
    private LandmarkMarkerManager landmarkMarkerManager;
    private JavaEditingMonitor javaEditingMonitor;
    private InterestUpdateDeltaListener javaElementChangeListener;
    private BreakpointEditorTracker breakpointEditorTracker;
    private static final String MYLYN_PREVIOUS_RUN = "org.eclipse.mylyn.ui.first.run.0_4_9";
    private static final String MYLYN_RUN_COUNT_3_1 = "org.eclipse.mylyn.java.ui.run.count.3_1_0";
    private static final String MYLYN_RUN_COUNT_3_10 = "org.eclipse.mylyn.java.ui.run.count.3_10_0";
    private static final String NUM_COMPUTERS_PREF_KEY = "content_assist_number_of_computers";

    public void start(BundleContext context) throws Exception {
        int count_3_10;
        super.start(context);
        INSTANCE = this;
        IPreferenceStore javaPrefs = JavaPlugin.getDefault().getPreferenceStore();
        int count = this.getPreferenceStore().getInt(MYLYN_RUN_COUNT_3_1);
        if (count < 1) {
            this.getPreferenceStore().setValue(MYLYN_RUN_COUNT_3_1, count + 1);
            if (count == 0 && this.getPreferenceStore().contains(MYLYN_PREVIOUS_RUN)) {
                this.changeProcessorCount(javaPrefs, -2);
            }
            new UIJob("Initialize Content Assist"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
                    JavaUiUtil.installContentAssist(store, true);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        if ((count_3_10 = this.getPreferenceStore().getInt(MYLYN_RUN_COUNT_3_10)) < 1) {
            this.getPreferenceStore().setValue(MYLYN_RUN_COUNT_3_10, count_3_10 + 1);
            if (Platform.getBundle((String)"org.eclipse.mylyn.pde.ui") != null && count > 0) {
                this.changeProcessorCount(javaPrefs, -1);
            }
        }
        String defaultValue = javaPrefs.getDefaultString("content_assist_disabled_computers");
        javaPrefs.setDefault("content_assist_disabled_computers", defaultValue + "org.eclipse.mylyn.java.ui.javaAllProposalCategory\u0000");
    }

    public void changeProcessorCount(IPreferenceStore javaPrefs, int delta) {
        int lastNumberOfComputers;
        if (javaPrefs.contains(NUM_COMPUTERS_PREF_KEY) && (lastNumberOfComputers = javaPrefs.getInt(NUM_COMPUTERS_PREF_KEY)) > 0) {
            javaPrefs.putValue(NUM_COMPUTERS_PREF_KEY, Integer.toString(lastNumberOfComputers + delta));
        }
    }

    private void lazyStart() {
        this.landmarkMarkerManager = new LandmarkMarkerManager();
        ContextCore.getContextManager().addListener((AbstractContextListener)this.landmarkMarkerManager);
        this.javaEditingMonitor = new JavaEditingMonitor();
        MonitorUi.getSelectionMonitors().add(this.javaEditingMonitor);
        this.installEditorTracker(PlatformUI.getWorkbench());
        this.javaElementChangeListener = new InterestUpdateDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        try {
            this.typeHistoryManager = new TypeHistoryManager();
            ContextCore.getContextManager().addListener((AbstractContextListener)this.typeHistoryManager);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not install type history manager: incompatible Eclipse version", t));
        }
        this.breakpointEditorTracker = new BreakpointEditorTracker();
        this.breakpointEditorTracker.install(PlatformUI.getWorkbench());
    }

    private void lazyStop() {
        if (this.typeHistoryManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.typeHistoryManager);
        }
        if (this.landmarkMarkerManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.landmarkMarkerManager);
        }
        if (this.javaEditingMonitor != null) {
            MonitorUi.getSelectionMonitors().remove((Object)this.javaEditingMonitor);
        }
        if (this.javaElementChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        }
        if (this.breakpointEditorTracker != null) {
            this.breakpointEditorTracker.dispose(PlatformUI.getWorkbench());
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference reference = iEditorReferenceArray[n4];
                    IEditorPart part = reference.getEditor(false);
                    if (part != null && part instanceof JavaEditor) {
                        JavaEditor editor = (JavaEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static JavaUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID_PLUGIN, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }

    public static class JavaUiBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            JavaUiBridgePlugin.getDefault().lazyStart();
        }
    }
}

