/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.metadata.Requirement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

public class RequiredPropertiesMatch
extends Requirement {
    private static final IExpression PROPERTIES_MATCH = ExpressionUtil.parse(String.format("%s.exists(cap | cap.%s == $0 && cap.%s ~= $1)", "providedCapabilities", "namespace", "properties"));

    public RequiredPropertiesMatch(String namespace, IFilterExpression attrFilter, IMatchExpression<IInstallableUnit> envFilter, int min, int max, boolean greedy, String description) {
        super(RequiredPropertiesMatch.createMatchExpressionFromFilter(namespace, attrFilter, description), envFilter, min, max, greedy, description);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(RequiredPropertiesMatch.extractNamespace(this.getMatches()));
        result.append("; ");
        result.append(RequiredPropertiesMatch.extractPropertiesMatch(this.getMatches()));
        this.appendDetails(result);
        return result.toString();
    }

    public static IMatchExpression<IInstallableUnit> createMatchExpressionFromFilter(String namespace, IFilterExpression attrFilter, String description) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)attrFilter, (String)("Filter is missing for required capability " + namespace + " in bundle " + description));
        IExpressionFactory factory = ExpressionUtil.getFactory();
        return factory.matchExpression(PROPERTIES_MATCH, namespace, attrFilter);
    }

    public static String extractNamespace(IMatchExpression<IInstallableUnit> matchExpression) {
        RequiredPropertiesMatch.assertValid(matchExpression);
        return (String)matchExpression.getParameters()[0];
    }

    public static IFilterExpression extractPropertiesMatch(IMatchExpression<IInstallableUnit> matchExpression) {
        RequiredPropertiesMatch.assertValid(matchExpression);
        return (IFilterExpression)matchExpression.getParameters()[1];
    }

    public static boolean isPropertiesMatchRequirement(IMatchExpression<IInstallableUnit> matchExpression) {
        return PROPERTIES_MATCH.equals(ExpressionUtil.getOperand(matchExpression));
    }

    private static void assertValid(IMatchExpression<IInstallableUnit> matchExpression) {
        if (!RequiredPropertiesMatch.isPropertiesMatchRequirement(matchExpression)) {
            throw new IllegalArgumentException();
        }
    }
}

