/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.TypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IHandlerTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.designtime.internal.Messages;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataLoader;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataMapper;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagMapping;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagToViewObjectMapping;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultTagTypeInfo;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.JSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.MetadataAttributeAdvisor;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDComponentTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDConverterTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagHandlerElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDValidatorTagElement;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.osgi.framework.Version;

public class DefaultJSPTagResolver
extends JSPTagResolvingStrategy {
    public static final String ID = "org.eclipse.jst.jsf.metadata.DefaultJSPTagResolver";
    public static final String DISPLAY_NAME = Messages.DefaultJSPTagResolver_DisplayName;
    private final ViewMetadataLoader _loader;
    private final ViewMetadataMapper _mapper;

    public static JSPTagResolvingStrategy.StrategyDescriptor createDescriptor() {
        return new JSPTagResolvingStrategy.StrategyDescriptor(ID, DISPLAY_NAME);
    }

    public DefaultJSPTagResolver(IProject project) {
        this._loader = new ViewMetadataLoader(project);
        this._mapper = new ViewMetadataMapper();
    }

    @Override
    public ITagElement resolve(TLDElementDeclaration elementDecl) {
        TagIdentifier tagId = TagIdentifierFactory.createTLDTagWrapper(elementDecl);
        TagMapping mapping = this._loader.getTagToViewMapping(tagId);
        TypeInfo elementType = null;
        if (mapping != null) {
            elementType = this.findTypeInfo(mapping, "1.1", null);
        }
        if (elementType instanceof ComponentTypeInfo) {
            return new TLDComponentTagElement(elementDecl, (ComponentTypeInfo)elementType, new MetadataAttributeAdvisor(tagId, this._loader, elementDecl));
        }
        if (elementType instanceof ConverterTypeInfo) {
            return new TLDConverterTagElement(elementDecl, (ConverterTypeInfo)elementType, new MetadataAttributeAdvisor(tagId, this._loader, elementDecl));
        }
        if (elementType instanceof ValidatorTypeInfo) {
            return new TLDValidatorTagElement(elementDecl, (ValidatorTypeInfo)elementType, new MetadataAttributeAdvisor(tagId, this._loader, elementDecl));
        }
        if (elementType instanceof IHandlerTagElement.TagHandlerType) {
            return new TLDTagHandlerElement(elementDecl, (IHandlerTagElement.TagHandlerType)elementType, new MetadataAttributeAdvisor(tagId, this._loader, elementDecl));
        }
        if (DefaultTagTypeInfo.isDefaultLib(tagId.getUri())) {
            return new TLDTagElement(elementDecl, new IAttributeAdvisor.NullAttributeAdvisor());
        }
        return null;
    }

    private TypeInfo findTypeInfo(TagMapping mapping, String jsfVersion, String libVersion) {
        EList<TagToViewObjectMapping> list = mapping.getVersionedTagToViewMappings();
        for (Object obj : list) {
            if (!(obj instanceof TagToViewObjectMapping)) continue;
            TagToViewObjectMapping viewMapping = (TagToViewObjectMapping)obj;
            String minJsfVersionString = viewMapping.getMinJSFVersion();
            if (minJsfVersionString != null) {
                try {
                    Version version = new Version(jsfVersion);
                    Version minVersion = Version.parseVersion((String)minJsfVersionString);
                    if (version.compareTo(minVersion) < 0) {
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            String minLibVersionString = viewMapping.getMinLibraryVersion();
            if (libVersion != null && minLibVersionString != null) {
                try {
                    Version version = new Version(libVersion);
                    Version minLibVersion = Version.parseVersion((String)minLibVersionString);
                    if (version.compareTo(minLibVersion) < 0) {
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            return this._mapper.mapToFrameworkData(viewMapping.getTypeInfo());
        }
        return null;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

