/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CompareResultDialog
extends TrayDialog {
    private static final String PREFIX_SUFFIX_PROPERTY = "org.eclipse.jdt.internal.junit.ui.CompareResultDialog.prefixSuffix";
    private TextMergeViewer fViewer;
    private String fExpected;
    private String fActual;
    private String fTestName;
    private final int[] fPrefixSuffix = new int[2];

    public CompareResultDialog(Shell parentShell, TestElement element) {
        super(parentShell);
        this.setShellStyle(3184);
        this.setFailedTest(element);
    }

    private void setFailedTest(TestElement failedTest) {
        this.fTestName = failedTest.getTestName();
        this.fExpected = failedTest.getExpected();
        this.fActual = failedTest.getActual();
        this.computePrefixSuffix();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return DLTKTestingPlugin.getDefault().getDialogSettingsSection(((Object)((Object)this)).getClass().getName());
    }

    private void computePrefixSuffix() {
        int end = Math.min(this.fExpected.length(), this.fActual.length());
        int i = 0;
        while (i < end) {
            if (this.fExpected.charAt(i) != this.fActual.charAt(i)) break;
            ++i;
        }
        this.fPrefixSuffix[0] = i;
        int j = this.fExpected.length() - 1;
        int k = this.fActual.length() - 1;
        int l = 0;
        while (k >= i && j >= i) {
            if (this.fExpected.charAt(j) != this.fActual.charAt(k)) break;
            ++l;
            --k;
            --j;
        }
        this.fPrefixSuffix[1] = l;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DLTKTestingMessages.CompareResultDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.dltk.testing.result_compare_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, DLTKTestingMessages.CompareResultDialog_labelOK, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        CompareViewerPane pane = new CompareViewerPane(composite, 0x800800);
        pane.setText(this.fTestName);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        data.heightHint = this.convertHeightInCharsToPixels(13);
        pane.setLayoutData((Object)data);
        Control previewer = this.createPreviewer((Composite)pane);
        pane.setContent(previewer);
        GridData gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        CompareResultDialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setLeftLabel(DLTKTestingMessages.CompareResultDialog_expectedLabel);
        compareConfiguration.setLeftEditable(false);
        compareConfiguration.setRightLabel(DLTKTestingMessages.CompareResultDialog_actualLabel);
        compareConfiguration.setRightEditable(false);
        compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)Boolean.FALSE);
        compareConfiguration.setProperty(PREFIX_SUFFIX_PROPERTY, (Object)this.fPrefixSuffix);
        this.fViewer = new CompareResultMergeViewer(parent, 0, compareConfiguration);
        this.setCompareViewerInput();
        Control control = this.fViewer.getControl();
        control.addDisposeListener(e -> compareConfiguration.dispose());
        return control;
    }

    private void setCompareViewerInput() {
        if (!this.fViewer.getControl().isDisposed()) {
            this.fViewer.setInput((Object)new DiffNode((ITypedElement)new CompareElement(this.fExpected), (ITypedElement)new CompareElement(this.fActual)));
        }
    }

    public void setInput(TestElement failedTest) {
        this.setFailedTest(failedTest);
        this.setCompareViewerInput();
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private String fContent;

        public CompareElement(String content) {
            this.fContent = content;
        }

        public String getName() {
            return "<no name>";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.fContent.getBytes(StandardCharsets.UTF_8));
        }

        public String getCharset() throws CoreException {
            return "UTF-8";
        }
    }

    private static class CompareResultMergeViewer
    extends TextMergeViewer {
        private CompareResultMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
            super(parent, style, configuration);
        }

        protected void createControls(Composite composite) {
            super.createControls(composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.dltk.testing.result_compare_context");
        }

        protected void configureTextViewer(TextViewer textViewer) {
            if (textViewer instanceof SourceViewer) {
                int[] prefixSuffixOffsets = (int[])this.getCompareConfiguration().getProperty(CompareResultDialog.PREFIX_SUFFIX_PROPERTY);
                ((SourceViewer)textViewer).configure((SourceViewerConfiguration)new CompareResultViewerConfiguration(prefixSuffixOffsets));
            }
        }
    }

    private static class CompareResultViewerConfiguration
    extends SourceViewerConfiguration {
        private final int[] fPrefixSuffixOffsets;

        public CompareResultViewerConfiguration(int[] prefixSuffixOffsets) {
            this.fPrefixSuffixOffsets = prefixSuffixOffsets;
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = new PresentationReconciler();
            SimpleDamagerRepairer dr = new SimpleDamagerRepairer(this.fPrefixSuffixOffsets);
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            return reconciler;
        }

        private static class SimpleDamagerRepairer
        implements IPresentationDamager,
        IPresentationRepairer {
            private IDocument fDocument;
            private final int[] fPrefixSuffixOffsets2;

            public SimpleDamagerRepairer(int[] prefixSuffixOffsets) {
                this.fPrefixSuffixOffsets2 = prefixSuffixOffsets;
            }

            public void setDocument(IDocument document) {
                this.fDocument = document;
            }

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean changed) {
                return new Region(0, this.fDocument.getLength());
            }

            public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
                int prefix = this.fPrefixSuffixOffsets2[0];
                int suffix = this.fPrefixSuffixOffsets2[1];
                TextAttribute attr = new TextAttribute(Display.getDefault().getSystemColor(3), null, 1);
                presentation.addStyleRange(new StyleRange(prefix, this.fDocument.getLength() - suffix - prefix, attr.getForeground(), attr.getBackground(), attr.getStyle()));
            }
        }
    }
}

