/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    private static final long serialVersionUID = 4182783536358350118L;
    private final Node receiverNode;
    private String name;
    private Node argsNode;

    public AttrAssignNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        super(position, 102);
        this.receiverNode = receiverNode;
        this.name = name.intern();
        this.argsNode = argsNode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    public Instruction accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
    }

    public List childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }
}

