/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.heredoc;

import org.eclipse.dltk.ui.text.heredoc.HereDocEnabledPartitionScanner;
import org.eclipse.dltk.ui.text.heredoc.HereDocUtils;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public abstract class HereDocPartitionRule {
    private String fPartition;
    private String fStart;

    public HereDocPartitionRule(String start, IToken token) {
        this.fStart = start;
        this.fPartition = (String)token.getData();
    }

    public IToken evaluate(HereDocEnabledPartitionScanner scanner) {
        int c;
        StringBuffer buffer = new StringBuffer();
        while ((c = scanner.read()) != -1) {
            buffer.append((char)c);
            if (buffer.length() == this.fStart.length()) break;
        }
        if (buffer.toString().equals(this.fStart)) {
            return this.detectIdentifier((ICharacterScanner)scanner);
        }
        this.unwind((ICharacterScanner)scanner, buffer.length());
        return Token.UNDEFINED;
    }

    public IToken evaluate(HereDocEnabledPartitionScanner scanner, String partition) {
        int c;
        boolean readChar = false;
        StringBuffer buffer = new StringBuffer();
        String terminator = HereDocUtils.getTerminator(partition);
        while ((c = scanner.read()) != -1) {
            readChar = true;
            if (!this.isNewline((ICharacterScanner)scanner, c)) {
                buffer.append((char)c);
                continue;
            }
            if (buffer.toString().equals(terminator)) break;
            buffer.setLength(0);
        }
        if (!readChar) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        return this.createTerminator(terminator);
    }

    protected final IToken createIdentifier(String identifier) {
        return new Token((Object)HereDocUtils.createIdentifier(this.fPartition, identifier));
    }

    protected final Token createTerminator(String terminator) {
        return new Token((Object)HereDocUtils.createTerminator(this.fPartition, terminator));
    }

    protected abstract String extractIdentifier(String var1);

    protected final boolean isNewline(ICharacterScanner scanner, int c) {
        char[][] lineDelimiters = scanner.getLegalLineDelimiters();
        int i = 0;
        while (i < lineDelimiters.length) {
            if (c == lineDelimiters[i][0]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract String parseIdentifier(String var1);

    protected final void unwind(ICharacterScanner scanner, int length) {
        while (length > 0) {
            scanner.unread();
            --length;
        }
    }

    private IToken detectIdentifier(ICharacterScanner scanner) {
        int c;
        StringBuffer buffer = new StringBuffer();
        while ((c = scanner.read()) != -1) {
            if (this.isNewline(scanner, c)) break;
            buffer.append((char)c);
        }
        scanner.unread();
        String identifier = this.extractIdentifier(buffer.toString());
        if (identifier == null) {
            this.unwind(scanner, buffer.length());
            return Token.UNDEFINED;
        }
        this.unwind(scanner, buffer.length() - identifier.length());
        identifier = this.parseIdentifier(identifier);
        return this.createIdentifier(identifier);
    }
}

