/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.TopValueCollection;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IFunctionValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceExtensionFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceHandler;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceHandlerFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferencerVisitor;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeInferencerVisitorBase
extends ASTVisitor<IValueReference>
implements ITypeInferencerVisitor {
    protected final ITypeInferenceContext context;
    private Stack<IValueCollection> contexts = new Stack();
    private ITypeInferenceHandler[] handlers = null;
    protected JSProblemReporter reporter;
    protected ITypeChecker typeChecker;

    @Override
    public ITypeInferenceContext getContext() {
        return this.context;
    }

    @Override
    public IValueCollection peekContext() {
        return !this.contexts.isEmpty() ? this.contexts.peek() : null;
    }

    @Override
    public void enterContext(IValueCollection collection) {
        this.contexts.push(collection);
    }

    @Override
    public IValueCollection leaveContext() {
        return this.contexts.pop();
    }

    protected boolean inFunction() {
        return this.inFunction(false);
    }

    protected boolean inFunction(boolean ignoreBlocks) {
        int i = this.contexts.size();
        while (--i >= 0) {
            IValueCollection collection = (IValueCollection)this.contexts.get(i);
            if (!(collection instanceof IFunctionValueCollection) || ignoreBlocks && ((IFunctionValueCollection)collection).isInlineBlock()) continue;
            return true;
        }
        return false;
    }

    public TypeInferencerVisitorBase(ITypeInferenceContext context) {
        this.context = context;
    }

    public void initialize() {
        this.contexts.clear();
        this.contexts.push(new TopValueCollection(this.context));
        List<ITypeInferenceHandler> handlers = this.createHandlers();
        this.handlers = handlers != null && !handlers.isEmpty() ? handlers.toArray(new ITypeInferenceHandler[handlers.size()]) : null;
    }

    @Deprecated
    protected final void initialize0() {
    }

    protected List<ITypeInferenceHandler> createHandlers() {
        ArrayList<ITypeInferenceHandler> handlers = new ArrayList<ITypeInferenceHandler>();
        ITypeInferenceHandlerFactory[] iTypeInferenceHandlerFactoryArray = TypeInfoManager.getNodeHandlerFactories();
        int n = iTypeInferenceHandlerFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeInferenceHandlerFactory factory = iTypeInferenceHandlerFactoryArray[n2];
            ITypeInferenceHandler handler = factory.create(this.context, this);
            if (handler != null) {
                handlers.add(handler);
            }
            ++n2;
        }
        return handlers;
    }

    protected <E> List<E> createExtensions(Class<E> extensionClass) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        ITypeInferenceHandlerFactory[] iTypeInferenceHandlerFactoryArray = TypeInfoManager.getNodeHandlerFactories();
        int n = iTypeInferenceHandlerFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object extension;
            ITypeInferenceHandlerFactory factory = iTypeInferenceHandlerFactoryArray[n2];
            if (factory instanceof ITypeInferenceExtensionFactory && (extension = ((ITypeInferenceExtensionFactory)((Object)factory)).createExtension(this.context, this, extensionClass)) != null && extensionClass.isInstance(extension)) {
                extensions.add(extension);
            }
            ++n2;
        }
        return extensions;
    }

    public IValueReference visit(ASTNode node) {
        if (this.handlers != null) {
            ITypeInferenceHandler[] iTypeInferenceHandlerArray = this.handlers;
            int n = this.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeInferenceHandler handler = iTypeInferenceHandlerArray[n2];
                IValueReference result = handler.handle(node);
                if (result != ITypeInferenceHandler.CONTINUE) {
                    return result;
                }
                ++n2;
            }
        }
        return (IValueReference)super.visit(node);
    }

    public void done() {
        IValue value;
        IValueCollection collection = this.getCollection();
        if (collection instanceof ValueCollection && (value = ((ValueCollection)collection).getValue()) instanceof Value) {
            ((Value)value).resolveLazyValues(new HashSet<Value>());
        }
    }

    public IValueCollection getCollection() {
        return (IValueCollection)this.contexts.get(0);
    }

    protected IValueReference merge(IValueReference value1, IValueReference value2) {
        AnonymousValue reference = new AnonymousValue();
        reference.setValue(value1);
        reference.addValue(value2, false);
        return reference;
    }

    @Override
    public JSProblemReporter getProblemReporter() {
        return this.reporter;
    }

    @Override
    public void suppressProblems(IProblemIdentifier ... identifiers) {
        if (this.reporter != null) {
            ((Reporter)this.reporter).suppressProblems(identifiers);
        }
    }

    public ITypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    public void setTypeChecker(ITypeChecker typeChecker) {
        this.typeChecker = typeChecker;
    }
}

