/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.callhierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.compiler.env.MethodSourceCode;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;

public class RubyCalleeProcessor
implements ICalleeProcessor {
    protected static int EXACT_RULE = 8;
    private Map fSearchResults = new HashMap();
    private IMethod method;

    public RubyCalleeProcessor(IMethod method, IProgressMonitor monitor, IDLTKSearchScope scope) {
        this.method = method;
    }

    public Map doOperation() {
        CaleeSourceElementRequestor requestor = new CaleeSourceElementRequestor();
        ISourceElementParser parser = null;
        parser = DLTKLanguageManager.getSourceElementParser((String)"org.eclipse.dltk.ruby.core.nature");
        parser.setRequestor((ISourceElementRequestor)requestor);
        parser.parseSourceModule((ISourceModule)new MethodSourceCode(this.method), null);
        return this.fSearchResults;
    }

    public IMethod[] findMethods(String methodName, int argCount, int sourcePosition) {
        ArrayList<IModelElement> methods = new ArrayList<IModelElement>();
        org.eclipse.dltk.core.ISourceModule module = this.method.getSourceModule();
        try {
            IModelElement[] elements = module.codeSelect(sourcePosition, 1);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IMethod) {
                    methods.add(elements[i]);
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private class CaleeSourceElementRequestor
    implements ISourceElementRequestor {
        private CaleeSourceElementRequestor() {
        }

        public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        }

        public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
            String name = new String(methodName);
            int off = 0;
            try {
                off = RubyCalleeProcessor.this.method.getSourceRange().getOffset();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            SimpleReference ref = new SimpleReference(off + sourcePosition, off + sourceEndPosition, name);
            IMethod[] methods = RubyCalleeProcessor.this.findMethods(name, argCount, off + sourceEndPosition - 1);
            RubyCalleeProcessor.this.fSearchResults.put(ref, methods);
        }

        public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        }

        public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        }

        public void acceptTypeReference(char[] typeName, int sourcePosition) {
        }

        public void enterField(ISourceElementRequestor.FieldInfo info) {
        }

        public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo info) {
            return false;
        }

        public void enterMethod(ISourceElementRequestor.MethodInfo info) {
        }

        public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
        }

        public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
            return false;
        }

        public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
            return false;
        }

        public void enterModule() {
        }

        public void enterType(ISourceElementRequestor.TypeInfo info) {
        }

        public boolean enterTypeAppend(ISourceElementRequestor.TypeInfo info, String fullName, String delimiter) {
            return false;
        }

        public void exitField(int declarationEnd) {
        }

        public void exitMethod(int declarationEnd) {
        }

        public void exitModule(int declarationEnd) {
        }

        public void exitType(int declarationEnd) {
        }

        public void enterModuleRoot() {
        }

        public boolean enterTypeAppend(String fullName, String delimiter) {
            return false;
        }

        public void exitModuleRoot() {
        }
    }
}

