/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;

class TopLevelTypeProblemsLabelDecorator
extends ProblemsLabelDecorator {
    public TopLevelTypeProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        super(registry);
    }

    protected boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        if (!(sourceElement instanceof IType) || ((IType)sourceElement).getDeclaringType() != null) {
            return false;
        }
        ISourceModule cu = ((IType)sourceElement).getSourceModule();
        if (cu == null) {
            return false;
        }
        IType[] types = cu.getTypes();
        if (types.length < 1) {
            return false;
        }
        int firstTypeStartOffset = -1;
        ISourceRange range = types[0].getSourceRange();
        if (range != null) {
            firstTypeStartOffset = range.getOffset();
        }
        int lastTypeEndOffset = -1;
        range = types[types.length - 1].getSourceRange();
        if (range != null) {
            lastTypeEndOffset = range.getOffset() + range.getLength() - 1;
        }
        return pos < firstTypeStartOffset || pos > lastTypeEndOffset || this.isInside(pos, sourceElement.getSourceRange());
    }

    private boolean isInside(int pos, ISourceRange range) {
        if (range == null) {
            return false;
        }
        int offset = range.getOffset();
        return offset <= pos && pos < offset + range.getLength();
    }
}

