/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ScriptElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;
    private static final String LABELPROVIDERS_EXTENSION_POINT = "org.eclipse.dltk.ui.scriptElementLabelProviders";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_NATURE = "nature";
    private static Map labelProviders;

    static {
        labelProviders = null;
    }

    public ScriptElementImageProvider() {
        ISharedImages images = DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public void dispose() {
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IModelElement) {
            return this.getScriptImageDescriptor((IModelElement)element, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static void createProviders(IConfigurationElement[] elements) {
        labelProviders = new HashMap();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            try {
                ILabelProvider pr = (ILabelProvider)element.createExecutableExtension(ATTR_CLASS);
                String nature = element.getAttribute(ATTR_NATURE);
                labelProviders.put(nature, pr);
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
            ++i;
        }
    }

    private ILabelProvider getContributedLabelProvider(IModelElement element) {
        IDLTKLanguageToolkit languageToolkit;
        if (labelProviders == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(LABELPROVIDERS_EXTENSION_POINT);
            ScriptElementImageProvider.createProviders(elements);
        }
        if ((languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element)) == null) {
            return null;
        }
        String nature = languageToolkit.getNatureId();
        ILabelProvider provider = (ILabelProvider)labelProviders.get(nature);
        return provider;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = ScriptElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new ScriptElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getScriptImageDescriptor(IModelElement element, int flags) {
        int adornmentFlags = ScriptElementImageProvider.computeAdornmentFlags(element, flags);
        Point size = ScriptElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor descr = this.getBaseImageDescriptor(element, flags);
        if (descr != null) {
            return new ScriptElementImageDescriptor(descr, adornmentFlags, size);
        }
        return null;
    }

    public ImageDescriptor getBaseImageDescriptor(IModelElement element, int renderFlags) {
        Image img;
        ILabelProvider provider = this.getContributedLabelProvider(element);
        if (provider != null && (img = provider.getImage((Object)element)) != null) {
            return ImageDescriptor.createFromImage((Image)img);
        }
        try {
            switch (element.getElementType()) {
                case 9: {
                    IMethod method = (IMethod)element;
                    int flags = method.getFlags();
                    return ScriptElementImageProvider.getMethodImageDescriptor(flags);
                }
                case 8: {
                    IField member = (IField)element;
                    return ScriptElementImageProvider.getFieldImageDescriptor(member.getFlags());
                }
                case 7: {
                    IType type = (IType)element;
                    return ScriptElementImageProvider.getTypeImageDescriptor(type.getFlags(), ScriptElementImageProvider.useLightIcons(renderFlags));
                }
                case 10: {
                    return DLTKPluginImages.DESC_OBJS_PACKDECL;
                }
                case 3: {
                    IProjectFragment root = (IProjectFragment)element;
                    if (root.isExternal()) {
                        if (root.isArchive()) {
                            return DLTKPluginImages.DESC_OBJS_JAR_WSRC;
                        }
                        return DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                    }
                    return DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                }
                case 4: {
                    return this.getScriptFolderIcon(element, renderFlags);
                }
                case 5: {
                    boolean external = element instanceof IExternalSourceModule;
                    return this.getSourceModuleIcon(element, external, renderFlags);
                }
                case 2: {
                    IScriptProject jp = (IScriptProject)element;
                    if (jp.getProject().isOpen()) {
                        ImageDescriptor result;
                        IProject project = jp.getProject();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                        if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                            return result;
                        }
                        return DESC_OBJ_PROJECT;
                    }
                    return DESC_OBJ_PROJECT_CLOSED;
                }
                case 1: {
                    return null;
                }
            }
        }
        catch (ModelException e) {
            if (e.isDoesNotExist()) {
                return DLTKPluginImages.DESC_OBJS_UNKNOWN;
            }
            DLTKUIPlugin.log(e);
            return DLTKPluginImages.DESC_OBJS_GHOST;
        }
        Assert.isTrue((boolean)false, (String)DLTKUIMessages.ScriptImageLabelprovider_assert_wrongImage);
        return DLTKPluginImages.DESC_OBJS_GHOST;
    }

    private ImageDescriptor getSourceModuleIcon(IModelElement element, boolean external, int renderFlags) {
        return null;
    }

    private ImageDescriptor getScriptFolderIcon(IModelElement element, int renderFlags) {
        IScriptFolder fragment = (IScriptFolder)element;
        boolean containsScriptElements = false;
        try {
            containsScriptElements = fragment.hasChildren();
        }
        catch (ModelException modelException) {}
        try {
            if (!containsScriptElements && fragment.getForeignResources().length > 0) {
                return DLTKPluginImages.DESC_OBJS_EMPTY_PACKAGE_RESOURCES;
            }
            if (!containsScriptElements) {
                return DLTKPluginImages.DESC_OBJS_EMPTY_PACKAGE;
            }
        }
        catch (ModelException modelException) {}
        return DLTKPluginImages.DESC_OBJS_PACKAGE;
    }

    public static ImageDescriptor getFieldImageDescriptor(int flags) {
        if (Flags.isPrivate((int)flags)) {
            return DLTKPluginImages.DESC_FIELD_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return DLTKPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPublic((int)flags)) {
            return DLTKPluginImages.DESC_FIELD_PUBLIC;
        }
        return DLTKPluginImages.DESC_FIELD_DEFAULT;
    }

    public static ImageDescriptor getTypeImageDescriptor(int flags, boolean useLightIcons) {
        if (Flags.isInterface((int)flags)) {
            if (useLightIcons) {
                return DLTKPluginImages.DESC_OBJS_INTERFACEALT;
            }
        } else if (useLightIcons) {
            return DLTKPluginImages.DESC_OBJS_CLASSALT;
        }
        return ScriptElementImageProvider.getClassImageDescriptor(flags);
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if ((flags & 0x20000) != 0) {
            return DLTKPluginImages.DESC_OBJS_TEST;
        }
        if ((flags & 0x10000) != 0) {
            return DLTKPluginImages.DESC_OBJS_TESTCASE;
        }
        if ((flags & 0x1000) != 0) {
            return DLTKPluginImages.DESC_OBJS_NAMESPACE;
        }
        if ((flags & 0x800) != 0) {
            return DLTKPluginImages.DESC_OBJS_MODULE;
        }
        if ((flags & 0x10) != 0) {
            return DLTKPluginImages.DESC_OBJS_INTERFACE;
        }
        return DLTKPluginImages.DESC_OBJS_CLASS;
    }

    public static ImageDescriptor getMethodImageDescriptor(int flags) {
        if ((flags & 0x20) != 0) {
            return DLTKPluginImages.DESC_METHOD_PRIVATE;
        }
        if ((flags & 0x40) != 0) {
            return DLTKPluginImages.DESC_METHOD_PROTECTED;
        }
        if (false) {
            return DLTKPluginImages.DESC_METHOD_DEFAULT;
        }
        return DLTKPluginImages.DESC_METHOD_PUBLIC;
    }

    public static int computeAdornmentFlags(IModelElement element, int renderFlags) {
        int flags = 0;
        if (ScriptElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            try {
                IType declaringType;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                boolean isInterface = (declaringType = member.getDeclaringType()) != null && Flags.isInterface((int)declaringType.getFlags());
                int modifiers = member.getFlags();
                if (Flags.isAbstract((int)modifiers) && !isInterface) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers)) {
                    flags |= 2;
                }
                if (Flags.isStatic((int)modifiers)) {
                    flags |= 8;
                }
            }
            catch (ModelException modelException) {}
        }
        return flags;
    }
}

