/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.debug.ui.interpreters.LibraryContentProvider;
import org.eclipse.dltk.internal.debug.ui.interpreters.LibraryStandin;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.dialogs.TimeTriggeredProgressMonitorDialog;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractInterpreterLibraryBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "AbstractInterpreterLibraryBlock";
    protected boolean fInCallback = false;
    protected IInterpreterInstall fInterpreterInstall;
    protected IInterpreterInstallType fInterpreterInstallType;
    protected IFileHandle fHome;
    protected LibraryContentProvider fLibraryContentProvider;
    protected TreeViewer fLibraryViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    protected Button fDefaultButton;
    protected Button fRediscoverButton;
    private Button fEnabledButton;
    protected AddScriptInterpreterDialog fDialog;
    static /* synthetic */ Class class$0;

    protected AbstractInterpreterLibraryBlock(AddScriptInterpreterDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Composite comp2 = new Composite(comp, 0);
        topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp2.setLayout((Layout)topLayout);
        gd = new GridData(1808);
        comp2.setLayoutData((Object)gd);
        this.fLibraryViewer = this.createViewer(comp2);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = this.createLibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider(this.getLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.isEnableButtonSupported()) {
            this.fEnabledButton = new Button(comp2, 32);
            this.fEnabledButton.setText(InterpretersMessages.AbstractInterpreterLibraryBlock_setPathVisibleToDltk);
            this.fEnabledButton.addSelectionListener((SelectionListener)this);
            this.fLibraryViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (AbstractInterpreterLibraryBlock.this.fLibraryContentProvider.canEnable((IStructuredSelection)AbstractInterpreterLibraryBlock.this.fLibraryViewer.getSelection())) {
                        AbstractInterpreterLibraryBlock.this.fLibraryContentProvider.changeEnabled();
                        AbstractInterpreterLibraryBlock.this.updateButtons();
                    }
                }
            });
        }
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_7);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_4);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_5);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        this.fDefaultButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_9);
        this.fDefaultButton.addSelectionListener((SelectionListener)this);
        if (this.fDialog.isRediscoverSupported()) {
            this.fRediscoverButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterLibraryBlock_rediscover);
            this.fRediscoverButton.addSelectionListener((SelectionListener)this);
        }
        return comp;
    }

    protected boolean isEnableButtonSupported() {
        return false;
    }

    protected LibraryContentProvider createLibraryContentProvider() {
        return new LibraryContentProvider();
    }

    protected TreeViewer createViewer(Composite comp) {
        return new TreeViewer(comp);
    }

    public void restoreDefaultLibraries() {
        LibraryLocation[] libs = this.getLibrariesWithEnvironment(this.fDialog.getEnvironmentVariables());
        if (libs != null) {
            this.fLibraryContentProvider.setLibraries(libs);
            this.fLibraryContentProvider.initialize(this.getHomeDirectory(), this.fDialog.getEnvironmentVariables(), true);
        }
        this.update();
    }

    protected LibraryLocation[] getLibrariesWithEnvironment(final EnvironmentVariable[] environmentVariables) {
        final LibraryLocation[][] libs = new LibraryLocation[1][];
        final IFileHandle installLocation = this.getHomeDirectory();
        if (installLocation == null) {
            libs[0] = new LibraryLocation[0];
        } else {
            TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(null, 1000);
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        libs[0] = AbstractInterpreterLibraryBlock.this.getInterpreterInstallType().getDefaultLibraryLocations(installLocation, environmentVariables, monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return libs[0];
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void setHomeDirectory(IFileHandle file) {
        this.fHome = file;
    }

    protected IFileHandle getHomeDirectory() {
        return this.fHome;
    }

    public void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        int cfr_ignored_0 = this.fLibraryContentProvider.getLibraries().length;
        LibraryStandin[] standins = this.fLibraryContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.updateDialogStatus(status);
    }

    public void performApply(IInterpreterInstall install) {
        if (this.isDefaultLocations()) {
            install.setLibraryLocations(null);
        } else {
            LibraryLocation[] libs = this.fLibraryContentProvider.getLibraries();
            install.setLibraryLocations(libs);
        }
    }

    protected boolean isDefaultLocations() {
        LibraryLocation[] def;
        LibraryLocation[] libraryLocations = this.fLibraryContentProvider.getLibraries();
        IInterpreterInstall install = this.getInterpreterInstall();
        if (install == null || libraryLocations == null) {
            return true;
        }
        IFileHandle installLocation = install.getInstallLocation();
        if (installLocation != null && (def = this.getInterpreterInstallType().getDefaultLibraryLocations(installLocation, install.getEnvironmentVariables(), null)).length == libraryLocations.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)libraryLocations[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected IInterpreterInstall getInterpreterInstall() {
        return this.fInterpreterInstall;
    }

    protected IInterpreterInstallType getInterpreterInstallType() {
        return this.fInterpreterInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDefaultButton) {
            this.restoreDefaultLibraries();
        } else if (source == this.fRediscoverButton) {
            this.reDiscover(this.fDialog.getEnvironmentVariables(), null);
        } else if (source == this.fEnabledButton) {
            this.fLibraryContentProvider.changeEnabled();
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        LibraryLocation libs = this.add();
        if (libs == null) {
            return;
        }
        this.fLibraryContentProvider.add(new LibraryLocation[]{libs}, selection);
        this.fLibraryContentProvider.initialize(this.getHomeDirectory(), this.fDialog.getEnvironmentVariables(), false);
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        this.fRemoveButton.setEnabled(this.fLibraryContentProvider.canRemove(selection));
        boolean enableUp = true;
        boolean enableDown = true;
        Object[] libraries = this.fLibraryContentProvider.getElements(null);
        if (selection.isEmpty() || libraries.length == 0) {
            enableUp = false;
            enableDown = false;
            if (this.isEnableButtonSupported()) {
                this.fEnabledButton.setSelection(false);
                this.fEnabledButton.setEnabled(false);
            }
        } else {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            if (this.isEnableButtonSupported()) {
                this.fEnabledButton.setEnabled(this.fLibraryContentProvider.canEnable(selection));
            }
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element;
                Object lib = element = iter.next();
                if (this.isEnableButtonSupported() && selection.size() == 1) {
                    this.fEnabledButton.setSelection(this.fLibraryContentProvider.isEnabled(lib));
                }
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp && this.fLibraryContentProvider.canUp(selection));
        this.fDownButton.setEnabled(enableDown && this.fLibraryContentProvider.canUp(selection));
    }

    public void initializeFrom(IInterpreterInstall Interpreter, IInterpreterInstallType type) {
        this.fInterpreterInstall = Interpreter;
        this.fInterpreterInstallType = type;
        if (Interpreter != null) {
            LibraryLocation[][] libs;
            block5: {
                this.setHomeDirectory(Interpreter.getInstallLocation());
                libs = new LibraryLocation[1][];
                TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(null, 3000);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            libs[0] = ScriptRuntime.getLibraryLocations((IInterpreterInstall)AbstractInterpreterLibraryBlock.this.getInterpreterInstall(), (IProgressMonitor)monitor);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
            this.fLibraryContentProvider.setLibraries(libs[0]);
            this.fLibraryContentProvider.initialize(this.getHomeDirectory(), this.fDialog.getEnvironmentVariables(), false);
        }
        this.update();
    }

    protected abstract IBaseLabelProvider getLabelProvider();

    protected void updateDialogStatus(IStatus status) {
        this.fDialog.setSystemLibraryStatus(status);
        this.fDialog.updateStatusLine();
    }

    protected void setButtonLayoutData(Button button) {
        this.fDialog.setButtonLayoutData(button);
    }

    protected abstract IDialogSettings getDialogSettions();

    protected LibraryLocation add() {
        IEnvironmentUI ui;
        String res;
        IEnvironment environment = this.fDialog.getEnvironment();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ui.environment.IEnvironmentUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((res = (ui = (IEnvironmentUI)environment.getAdapter((Class)clazz)).selectFolder(this.fLibraryViewer.getControl().getShell())) == null) {
            return null;
        }
        IPath path = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)new Path(res));
        LibraryLocation lib = new LibraryLocation(path.makeAbsolute());
        return lib;
    }

    public void reDiscover(EnvironmentVariable[] environmentVariables, EnvironmentVariable[] oldVars) {
        this.fLibraryContentProvider.initialize(this.getHomeDirectory(), this.fDialog.getEnvironmentVariables(), false);
        this.update();
    }

    private boolean equals(EnvironmentVariable[] a, EnvironmentVariable[] b) {
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            vars.put(a[i].getName(), a[i]);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            EnvironmentVariable v = (EnvironmentVariable)vars.get(b[i].getName());
            if (v == null) {
                return false;
            }
            if (!v.getValue().equals(b[i].getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equals(LibraryLocation[] a, LibraryLocation[] b) {
        HashSet<LibraryLocation> libs = new HashSet<LibraryLocation>();
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            libs.add(a[i]);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            if (!libs.contains(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

