/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.dltk.core.DLTKCore;

public abstract class ScriptContentDescriber
implements ITextContentDescriber {
    public static final QualifiedName DLTK_VALID = new QualifiedName("org.eclipse.dltk.core", "valid");
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(true);
    private static final int BUFFER_LENGTH = 2048;
    private static final int HEADER_LENGTH = 4096;
    private static final int FOOTER_LENGTH = 4096;

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[]{DLTK_VALID};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkHeader(File file, Pattern[] headerPatterns, Pattern[] footerPatterns) throws FileNotFoundException, IOException {
        FileInputStream reader = null;
        try {
            block11: {
                block8: {
                    String header;
                    block10: {
                        byte[] buf;
                        block9: {
                            reader = new FileInputStream(file);
                            buf = new byte[2049];
                            int res = reader.read(buf);
                            if (res == -1) break block8;
                            if (res != 0) break block9;
                            break block8;
                        }
                        header = new String(buf);
                        if (!ScriptContentDescriber.checkBufferForPatterns(header, headerPatterns)) break block10;
                        break block11;
                    }
                    if (file.length() < 2048L && footerPatterns != null && ScriptContentDescriber.checkBufferForPatterns(header, footerPatterns)) break block11;
                }
                Object var7_6 = null;
                if (reader == null) return false;
                try {
                    reader.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            Object var7_7 = null;
            if (reader == null) return true;
            try {}
            catch (IOException iOException) {}
            reader.close();
            return true;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
    }

    private static boolean checkFooter(File file, Pattern[] footerPatterns) throws FileNotFoundException, IOException {
        RandomAccessFile raFile;
        block4: {
            raFile = new RandomAccessFile(file, "r");
            try {
                String content;
                long len = 2048L;
                long fileSize = raFile.length();
                long offset = fileSize - len;
                if (offset < 0L) {
                    offset = 0L;
                }
                raFile.seek(offset);
                byte[] buf = new byte[2049];
                int code = raFile.read(buf);
                if (code == -1 || !ScriptContentDescriber.checkBufferForPatterns(content = new String(buf, 0, code), footerPatterns)) break block4;
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                raFile.close();
                throw throwable;
            }
            raFile.close();
            return true;
        }
        Object var12_10 = null;
        raFile.close();
        return false;
    }

    private static boolean checkBufferForPatterns(CharSequence header, Pattern[] patterns) {
        if (patterns == null) {
            return false;
        }
        int i = 0;
        while (i < patterns.length) {
            Matcher m = patterns[i].matcher(header);
            if (m.find()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean checkPatterns(File file, Pattern[] headerPatterns, Pattern[] footerPatterns) {
        block4: {
            if (!ScriptContentDescriber.checkHeader(file, headerPatterns, footerPatterns)) break block4;
            return true;
        }
        try {
            return footerPatterns != null && file.length() > 2048L && ScriptContentDescriber.checkFooter(file, footerPatterns);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean checkPatterns(Reader stream, Pattern[] headerPatterns, Pattern[] footerPatterns) {
        String footer;
        String content;
        String header;
        StringBuffer buffer;
        block6: {
            BufferedReader reader = new BufferedReader(stream);
            buffer = new StringBuffer();
            char[] buff = new char[8096];
            try {
                int len;
                while ((len = reader.read(buff)) != -1) {
                    buffer.append(buff, 0, len);
                }
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if ((header = (content = buffer.toString())).length() > 4096) {
            header = header.substring(0, 4096);
        }
        if ((footer = content).length() > 4096) {
            footer = footer.substring(footer.length() - 4096, footer.length() - 1);
        }
        if (ScriptContentDescriber.checkBufferForPatterns(header, headerPatterns)) {
            return true;
        }
        return ScriptContentDescriber.checkBufferForPatterns(footer, footerPatterns);
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputStreamReader(contents), description);
    }
}

