/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.corext.callhierarchy.CallHierarchyVisitor;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodCall;
import org.eclipse.dltk.internal.ui.callhierarchy.MethodWrapperWorkbenchAdapter;

public abstract class MethodWrapper
extends PlatformObject {
    private Map fElements = null;
    private Map fMethodCache;
    private MethodCall fMethodCall;
    private MethodWrapper fParent;
    private int fLevel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        Assert.isNotNull((Object)methodCall);
        if (parent == null) {
            this.setMethodCache(new HashMap());
            this.fLevel = 1;
        } else {
            this.setMethodCache(parent.getMethodCache());
            this.fLevel = parent.getLevel() + 1;
        }
        this.fMethodCall = methodCall;
        this.fParent = parent;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getMember();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return new MethodWrapperWorkbenchAdapter(this);
        }
        return null;
    }

    public MethodWrapper[] getCalls(IProgressMonitor progressMonitor) {
        if (this.fElements == null) {
            this.doFindChildren(progressMonitor);
        }
        MethodWrapper[] result = new MethodWrapper[this.fElements.size()];
        int i = 0;
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iter.next());
            result[i++] = this.createMethodWrapper(methodCall);
        }
        return result;
    }

    public int getLevel() {
        return this.fLevel;
    }

    public IModelElement getMember() {
        return this.getMethodCall().getMember();
    }

    public MethodCall getMethodCall() {
        return this.fMethodCall;
    }

    public String getName() {
        if (this.getMethodCall() != null) {
            return this.getMethodCall().getMember().getElementName();
        }
        return "";
    }

    public MethodWrapper getParent() {
        return this.fParent;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof MethodWrapperWorkbenchAdapter) {
            oth = ((MethodWrapperWorkbenchAdapter)oth).getMethodWrapper();
        }
        if (oth.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MethodWrapper other = (MethodWrapper)((Object)oth);
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals((Object)other.fParent)) {
            return false;
        }
        return !(this.getMethodCall() == null ? other.getMethodCall() != null : !this.getMethodCall().equals(other.getMethodCall()));
    }

    public int hashCode() {
        int result = 0;
        if (this.fParent != null) {
            result = 1000003 * result + this.fParent.hashCode();
        }
        if (this.getMethodCall() != null) {
            result = 1000003 * result + this.getMethodCall().getMember().hashCode();
        }
        return result;
    }

    private void setMethodCache(Map methodCache) {
        this.fMethodCache = methodCache;
    }

    protected abstract String getTaskName();

    private void addCallToCache(MethodCall methodCall) {
        Map cachedCalls = this.lookupMethod(this.getMethodCall());
        cachedCalls.put(methodCall.getKey(), methodCall);
    }

    protected abstract MethodWrapper createMethodWrapper(MethodCall var1);

    /*
     * Exception decompiling
     */
    private void doFindChildren(IProgressMonitor progressMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 86->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isRecursive() {
        MethodWrapper current = this.getParent();
        while (current != null) {
            if (this.getMember().getHandleIdentifier().equals(current.getMember().getHandleIdentifier())) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    protected abstract Map findChildren(IProgressMonitor var1);

    private Map getMethodCache() {
        return this.fMethodCache;
    }

    private void initCalls() {
        this.fElements = new HashMap();
        this.initCacheForMethod();
    }

    private Map lookupMethod(MethodCall methodCall) {
        return (Map)this.getMethodCache().get(methodCall.getKey());
    }

    private void performSearch(IProgressMonitor progressMonitor) {
        this.fElements = this.findChildren(progressMonitor);
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            this.checkCanceled(progressMonitor);
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iter.next());
            this.addCallToCache(methodCall);
        }
    }

    private MethodCall getMethodCallFromMap(Map elements, Object key) {
        return (MethodCall)elements.get(key);
    }

    private void initCacheForMethod() {
        HashMap cachedCalls = new HashMap();
        this.getMethodCache().put(this.getMethodCall().getKey(), cachedCalls);
    }

    protected void checkCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void accept(CallHierarchyVisitor visitor, IProgressMonitor progressMonitor) {
        if (this.getParent() != null && this.getParent().isRecursive()) {
            return;
        }
        this.checkCanceled(progressMonitor);
        visitor.preVisit(this);
        if (visitor.visit(this)) {
            MethodWrapper[] methodWrappers = this.getCalls(progressMonitor);
            int i = 0;
            while (i < methodWrappers.length) {
                methodWrappers[i].accept(visitor, progressMonitor);
                ++i;
            }
        }
        visitor.postVisit(this);
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
    }
}

