/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.launcher.DLTKTestingLaunchConfigurationConstants;
import org.eclipse.dltk.internal.testing.model.ITestRunSessionListener;
import org.eclipse.dltk.internal.testing.model.ITestSessionListener;
import org.eclipse.dltk.internal.testing.model.ModelMessages;
import org.eclipse.dltk.internal.testing.model.TestCaseElement;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.model.TestRunHandler;
import org.eclipse.dltk.internal.testing.model.TestRunSession;
import org.eclipse.dltk.internal.testing.model.TestRunSessionSerializer;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestRunListener;
import org.eclipse.dltk.testing.ITestSession;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DLTKTestingModel {
    private final ListenerList fTestRunSessionListeners = new ListenerList();
    private final LinkedList fTestRunSessions = new LinkedList();
    private final ILaunchListener fLaunchListener = new DLTKTestingLaunchListener();

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("project", null);
            if (projectName != null && projectName.length() > 0) {
                return DLTKCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public void start() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener(this.fLaunchListener);
        this.addTestRunSessionListener(new LegacyTestRunSessionListener());
    }

    public void stop() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener(this.fLaunchListener);
        File historyDirectory = DLTKTestingPlugin.getHistoryDirectory();
        File[] swapFiles = historyDirectory.listFiles();
        if (swapFiles != null) {
            int i = 0;
            while (i < swapFiles.length) {
                swapFiles[i].delete();
                ++i;
            }
        }
    }

    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    public List getTestRunSessions() {
        return new ArrayList(this.fTestRunSessions);
    }

    public TestRunSession getTestRunSession(ILaunch launch) {
        Iterator it = this.fTestRunSessions.iterator();
        while (it.hasNext()) {
            TestRunSession session = (TestRunSession)it.next();
            if (!session.getLaunch().getAttribute("org.eclipse.dltk.testing.TEST_KIND").equals(launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND"))) continue;
            return session;
        }
        return null;
    }

    public void addTestRunSession(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        Assert.isLegal((!this.fTestRunSessions.contains(testRunSession) ? 1 : 0) != 0);
        this.fTestRunSessions.addFirst(testRunSession);
        this.notifyTestRunSessionAdded(testRunSession);
    }

    public static ITestSession importTestRunSession(File file) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler();
            parser.parse(file, (DefaultHandler)handler);
            TestRunSession session = handler.getTestRunSession();
            DLTKTestingPlugin.getModel().addTestRunSession(session);
            return session;
        }
        catch (ParserConfigurationException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        catch (SAXException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        catch (IOException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        return null;
    }

    public static void importIntoTestRunSession(File swapFile, TestRunSession testRunSession) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler(testRunSession);
            parser.parse(swapFile, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
        catch (SAXException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
        catch (IOException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
    }

    /*
     * Exception decompiling
     */
    public static void exportTestRunSession(TestRunSession testRunSession, File file) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 76->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void exportTestRunSession(TestRunSession testRunSession, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        InputSource inputSource = new InputSource();
        SAXSource source = new SAXSource(new TestRunSessionSerializer(testRunSession), inputSource);
        StreamResult result = new StreamResult(out);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        transformer.transform(source, result);
    }

    private static void throwExportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_write, file.getAbsolutePath()), (Throwable)e));
    }

    private static void throwImportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_read, file.getAbsolutePath()), (Throwable)e));
    }

    public void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed = this.fTestRunSessions.remove(testRunSession);
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
        testRunSession.removeSwapFile();
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        testRunSession.stopTestRun();
        ILaunch launch = testRunSession.getLaunch();
        if (launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionRemoved(testRunSession);
            ++i;
        }
    }

    private void notifyTestRunSessionAdded(TestRunSession testRunSession) {
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionAdded(testRunSession);
            ++i;
        }
    }

    private final class DLTKTestingLaunchListener
    implements ILaunchListener {
        private HashSet fTrackedLaunches = new HashSet(20);

        private DLTKTestingLaunchListener() {
        }

        public void launchAdded(ILaunch launch) {
            this.fTrackedLaunches.add(launch);
        }

        public void launchRemoved(ILaunch launch) {
            this.fTrackedLaunches.remove(launch);
        }

        public void launchChanged(ILaunch launch) {
            if (!this.fTrackedLaunches.contains(launch)) {
                return;
            }
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config == null) {
                return;
            }
            IScriptProject javaProject = DLTKTestingLaunchConfigurationConstants.getScriptProject(config);
            if (javaProject == null) {
                return;
            }
            String atr = launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND");
            if (atr != null) {
                this.fTrackedLaunches.remove(launch);
                this.getDisplay().asyncExec(new Runnable(this, launch, javaProject){
                    final /* synthetic */ DLTKTestingLaunchListener this$1;
                    private final /* synthetic */ ILaunch val$launch;
                    private final /* synthetic */ IScriptProject val$javaProject;
                    {
                        this.this$1 = dLTKTestingLaunchListener;
                        this.val$launch = iLaunch;
                        this.val$javaProject = iScriptProject;
                    }

                    public void run() {
                        DLTKTestingLaunchListener.access$1(this.this$1, this.val$launch, this.val$javaProject);
                    }
                });
            }
        }

        private void connectTestRunner(ILaunch launch, IScriptProject javaProject) {
            this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
            int maxCount = DLTKTestingPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.dltk.testing.max_test_runs");
            int toDelete = DLTKTestingModel.this.fTestRunSessions.size() - maxCount;
            while (toDelete > 0) {
                --toDelete;
                TestRunSession session = (TestRunSession)DLTKTestingModel.this.fTestRunSessions.removeLast();
                DLTKTestingModel.this.notifyTestRunSessionRemoved(session);
            }
            TestRunSession testRunSession = new TestRunSession(launch, javaProject);
            DLTKTestingModel.this.addTestRunSession(testRunSession);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
            TestRunnerViewPart testRunnerViewPart;
            IWorkbenchPage page;
            IWorkbenchPart activePart;
            block9: {
                block8: {
                    TestRunnerViewPart testRunnerViewPart2;
                    block7: {
                        activePart = null;
                        page = null;
                        try {
                            try {
                                if (testRunner != null && testRunner.isCreated()) {
                                    testRunnerViewPart2 = testRunner;
                                    Object var5_6 = null;
                                    if (page == null) return testRunnerViewPart2;
                                    if (activePart == null) return testRunnerViewPart2;
                                    break block7;
                                }
                                page = DLTKTestingPlugin.getActivePage();
                                if (page == null) {
                                    break block8;
                                }
                                activePart = page.getActivePart();
                                testRunnerViewPart = (TestRunnerViewPart)page.showView("org.eclipse.dltk.testing.ResultView");
                                break block9;
                            }
                            catch (PartInitException pie) {
                                DLTKTestingPlugin.log(pie);
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            if (page == null) throw throwable;
                            if (activePart == null) throw throwable;
                            page.activate(activePart);
                            throw throwable;
                        }
                    }
                    page.activate(activePart);
                    return testRunnerViewPart2;
                }
                Object var5_7 = null;
                if (page == null) return null;
                if (activePart == null) return null;
                page.activate(activePart);
                return null;
            }
            Object var5_8 = null;
            if (page == null) return testRunnerViewPart;
            if (activePart == null) return testRunnerViewPart;
            page.activate(activePart);
            return testRunnerViewPart;
        }

        private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
            IWorkbenchPage page = DLTKTestingPlugin.getActivePage();
            if (page == null) {
                return null;
            }
            return (TestRunnerViewPart)page.findView("org.eclipse.dltk.testing.ResultView");
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            return display;
        }

        static /* synthetic */ void access$1(DLTKTestingLaunchListener dLTKTestingLaunchListener, ILaunch iLaunch, IScriptProject iScriptProject) {
            dLTKTestingLaunchListener.connectTestRunner(iLaunch, iScriptProject);
        }
    }

    private static final class LegacyTestRunSessionListener
    implements ITestRunSessionListener {
        private TestRunSession fActiveTestRunSession;
        private ITestSessionListener fTestSessionListener;

        private LegacyTestRunSessionListener() {
        }

        public void sessionAdded(TestRunSession testRunSession) {
            if (this.fActiveTestRunSession != null) {
                return;
            }
            this.fActiveTestRunSession = testRunSession;
            this.fTestSessionListener = new ITestSessionListener(this){
                final /* synthetic */ LegacyTestRunSessionListener this$1;
                {
                    this.this$1 = legacyTestRunSessionListener;
                }

                public void testAdded(TestElement testElement) {
                }

                public void sessionStarted() {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunStarted(LegacyTestRunSessionListener.access$0(this.this$1).getTotalCount());
                        ++i;
                    }
                }

                public void sessionTerminated() {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunTerminated();
                        ++i;
                    }
                    this.this$1.sessionRemoved(LegacyTestRunSessionListener.access$0(this.this$1));
                }

                public void sessionStopped(long elapsedTime) {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunStopped(elapsedTime);
                        ++i;
                    }
                    this.this$1.sessionRemoved(LegacyTestRunSessionListener.access$0(this.this$1));
                }

                public void sessionEnded(long elapsedTime) {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunEnded(elapsedTime);
                        ++i;
                    }
                    this.this$1.sessionRemoved(LegacyTestRunSessionListener.access$0(this.this$1));
                }

                public void runningBegins() {
                }

                public void testStarted(TestCaseElement testCaseElement) {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testStarted(testCaseElement.getId(), testCaseElement.getTestName());
                        ++i;
                    }
                }

                public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual, int code) {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testFailed(status.getOldCode(), testElement.getId(), testElement.getTestName(), trace);
                        ++i;
                    }
                }

                public void testEnded(TestCaseElement testCaseElement) {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testEnded(testCaseElement.getId(), testCaseElement.getTestName());
                        ++i;
                    }
                }

                public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
                    ITestRunListener[] testRunListeners = DLTKTestingPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testReran(testCaseElement.getId(), testCaseElement.getClassName(), testCaseElement.getTestMethodName(), status.getOldCode(), trace);
                        ++i;
                    }
                }

                public boolean acceptsSwapToDisk() {
                    return true;
                }
            };
            this.fActiveTestRunSession.addTestSessionListener(this.fTestSessionListener);
        }

        public void sessionRemoved(TestRunSession testRunSession) {
            if (this.fActiveTestRunSession == testRunSession) {
                this.fActiveTestRunSession.removeTestSessionListener(this.fTestSessionListener);
                this.fTestSessionListener = null;
                this.fActiveTestRunSession = null;
            }
        }

        static /* synthetic */ TestRunSession access$0(LegacyTestRunSessionListener legacyTestRunSessionListener) {
            return legacyTestRunSessionListener.fActiveTestRunSession;
        }
    }
}

