/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.eclipse.actf.util.win32.IIntervalExec;
import org.eclipse.actf.util.win32.OverlayLabel;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OverlayWindow
implements Runnable {
    public static final String WINDOW_TEXT = "[Overlay Window]";
    public static final int INDEX_HIGHLIGHT = 0;
    public static final int INDEX_LABELS = 1;
    private static boolean visible = true;
    private Shell shell = new Shell(16392);
    private Display display;
    private static OverlayWindow[] instance = new OverlayWindow[2];

    private OverlayWindow(int index) {
        this.shell.setText(WINDOW_TEXT);
        this.shell.setBackground(this.shell.getBackground());
        this.display = this.shell.getDisplay();
        Shell activeShell = this.display.getActiveShell();
        if (activeShell != null) {
            activeShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    OverlayWindow.this.shell.dispose();
                }
            });
        }
        OverlayWindow.setLayered((Control)this.shell, index == 0);
        this.shell.setLayout((Layout)new GridLayout());
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rect = env.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        this.shell.setBounds(0, 0, rect.width, rect.height);
        this.shell.setVisible(visible);
        if (1 == index) {
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellDeactivated(ShellEvent e) {
                    OverlayLabel.removeAll();
                }
            });
        }
    }

    public static OverlayWindow getInstance(int index, boolean create) {
        if (index < instance.length) {
            if (create && (instance[index] == null || instance[index].getComposite().isDisposed())) {
                OverlayWindow.instance[index] = new OverlayWindow(index);
            }
            return instance[index];
        }
        return null;
    }

    public static boolean getVisible() {
        return visible;
    }

    public static void setVisible(boolean newVisible) {
        if (visible != newVisible) {
            visible = newVisible;
            int i = 0;
            while (i < instance.length) {
                if (instance[i] != null) {
                    OverlayWindow.instance[i].shell.setVisible(visible);
                }
                ++i;
            }
        }
    }

    public Composite getComposite() {
        return this.shell;
    }

    public void run() {
        if (!this.shell.isDisposed()) {
            Control[] children = this.shell.getChildren();
            int i = 0;
            while (i < children.length) {
                int nextInterval;
                if (children[i] instanceof IIntervalExec && (nextInterval = ((IIntervalExec)children[i]).exec()) > 0) {
                    this.display.timerExec(nextInterval, (Runnable)this);
                }
                ++i;
            }
        }
    }

    private static void setLayered(Control control, boolean transparent) {
        int ws = OS.GetWindowLongW((int)control.handle, (int)-20);
        ws |= 0x80000;
        if (transparent) {
            ws |= 0x20;
        }
        OS.SetWindowLong((int)control.handle, (int)-20, (int)ws);
        WindowUtil.SetLayeredWindowAttributes(control.handle, control.getBackground().handle, '\u0000', 1);
    }
}

