/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.content.IStyleListener;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableCellElementImpl
extends ODFStylableElementImpl
implements TableCellElement {
    private static final long serialVersionUID = -4617536939760820397L;

    protected TableCellElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    @Override
    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    @Override
    public int getTableIndex() {
        TableElement tableElement = this.getTableElement();
        return tableElement.getTableIndex();
    }

    @Override
    public TableElement getTableElement() {
        TableElement tableElement = null;
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof TableElement) {
                tableElement = (TableElement)parent;
                break;
            }
            parent = parent.getParentNode();
        }
        return tableElement;
    }

    @Override
    public int getTableColIndex() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> rowList = tableElement.getTableRowChildren();
        if (rowList == null) {
            return -1;
        }
        int i = 0;
        while (i < rowList.size()) {
            TableRowElement row = rowList.get(i);
            List<TableCellElement> cellList = row.getTableCellChildren();
            if (cellList != null) {
                int j = 0;
                while (j < cellList.size()) {
                    if (cellList.get(j).equals(this)) {
                        return j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getTableRowIndex() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> rowList = tableElement.getTableRowChildren();
        if (rowList == null) {
            return -1;
        }
        int i = 0;
        while (i < rowList.size()) {
            TableRowElement row = rowList.get(i);
            List<TableCellElement> cellList = row.getTableCellChildren();
            if (cellList != null) {
                int j = 0;
                while (j < cellList.size()) {
                    if (cellList.get(j).equals(this)) {
                        return i;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getTableColSize() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> rowList = tableElement.getTableRowChildren();
        if (rowList == null) {
            return -1;
        }
        int i = 0;
        while (i < rowList.size()) {
            TableRowElement row = rowList.get(i);
            List<TableCellElement> cellList = row.getTableCellChildren();
            if (cellList != null) {
                int j = 0;
                while (j < cellList.size()) {
                    if (cellList.get(j).equals(this)) {
                        return cellList.size();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getTableRowSize() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> rowList = tableElement.getTableRowChildren();
        if (rowList == null) {
            return -1;
        }
        return rowList.size();
    }

    @Override
    public String getAttrOfficeValue() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value");
        }
        return null;
    }

    @Override
    public String getAttrOfficeValueType() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
        }
        return null;
    }

    @Override
    public String getAttrTableFormula() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "formula")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "formula");
        }
        return null;
    }

    @Override
    public int getAttrTableNumberColumnsRepeated() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated"));
        }
        return -1;
    }

    @Override
    public int getAttrTableNumberColumnsSpanned() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned"));
        }
        return -1;
    }

    @Override
    public void setValue(String value) {
        this.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value", value);
    }

    @Override
    public String getValue() {
        return this.getAttrOfficeValue();
    }

    @Override
    public void setStyle(StyleElement style) {
    }

    @Override
    public StyleElement getStyle() {
        String styleName;
        ODFElement elem;
        Element root = this.getOwnerDocument().getDocumentElement();
        if (root instanceof ODFElementImpl && (elem = ((ODFElementImpl)root).findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", styleName = this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name"))) != null && elem instanceof StyleElement) {
            return (StyleElement)elem;
        }
        return null;
    }

    @Override
    public void addStyleListener(IStyleListener listener, String topic) {
    }

    @Override
    public void removeStyleListener(IStyleListener listener, String topic) {
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }
}

