/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.DrawingObjectBaseElementImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.draw.GElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.svg.DescElement;
import org.eclipse.actf.model.dom.odf.svg.TitleElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DrawingObjectElementImpl
extends DrawingObjectBaseElementImpl
implements DrawingObjectElement {
    private static final long serialVersionUID = -934587640960571482L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0' and local-name()='title')]");
    private static final Object EXP2 = xpathService.compile("./*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0' and local-name()='desc')]");

    protected DrawingObjectElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    public String getAttrDrawCaptionId() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "caption-id")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "caption-id");
        }
        return null;
    }

    public long getHeight() {
        return -1L;
    }

    public long getWidth() {
        return -1L;
    }

    public long getX() {
        return -1L;
    }

    public long getY() {
        return -1L;
    }

    public void setHeight(long height) {
    }

    public void setWidth(long width) {
    }

    public void setX(long x) {
    }

    public void setY(long y) {
    }

    public long getPageIndex() {
        PageElement page = null;
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof PageElement) {
                page = (PageElement)parent;
                break;
            }
            if (parent instanceof BodyElement) break;
            parent = parent.getParentNode();
        }
        if (page != null) {
            return page.getPageIndex();
        }
        Node sheet = null;
        parent = this.getParentNode();
        while (parent != null) {
            Node gparent;
            if (parent instanceof TableElement && (gparent = parent.getParentNode()) instanceof SpreadSheetElement) {
                sheet = (TableElement)parent;
                break;
            }
            if (parent instanceof BodyElement) break;
            parent = parent.getParentNode();
        }
        if (sheet != null) {
            int sheetIndex = 0;
            Node preSib = sheet.getPreviousSibling();
            while (preSib != null) {
                if (preSib instanceof TableElement) {
                    ++sheetIndex;
                }
                preSib = preSib.getPreviousSibling();
            }
            return sheetIndex;
        }
        return -1L;
    }

    public long getZIndex() {
        DocumentContentElement content;
        ODFConstants.ContentType type;
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "z-index")) {
            try {
                return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "z-index")).intValue();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((type = (content = (DocumentContentElement)this.odfDoc.getDocumentElement()).getBodyElement().getContent().getContentType()) == ODFConstants.ContentType.PRESENTATION || type == ODFConstants.ContentType.DRAW) {
            Node parent = this.getParentNode();
            if (parent instanceof PageElement) {
                int zIndex = 0;
                Node preNode = this.getPreviousSibling();
                while (preNode != null) {
                    NodeList nl;
                    if (preNode instanceof DrawingObjectElement) {
                        ++zIndex;
                    } else if (preNode instanceof Element && (nl = ((Element)preNode).getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "control")) != null && nl.getLength() > 0) {
                        zIndex += nl.getLength();
                    }
                    preNode = preNode.getPreviousSibling();
                }
                return zIndex;
            }
            if (parent instanceof GElement) {
                return ((GElement)parent).getZIndex();
            }
        }
        return -1L;
    }

    public TextBoxElement getBoundCaptionTextBoxElement() {
        ODFDocument odfDoc = (ODFDocument)this.getOwnerDocument();
        return this.getBoundCaptionTextBoxElement(odfDoc.getODFVersion());
    }

    public TextBoxElement getBoundCaptionTextBoxElement(double version) {
        if (version == 1.0) {
            return null;
        }
        String captionId = this.getAttrDrawCaptionId();
        if (captionId == null) {
            return null;
        }
        ODFDocument odfDoc = (ODFDocument)this.getOwnerDocument();
        ODFElementImpl root = (ODFElementImpl)odfDoc.getDocumentElement();
        ODFElement elem = root.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "text-box", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "id", captionId);
        if (elem != null && elem instanceof TextBoxElement) {
            return (TextBoxElement)elem;
        }
        new ODFException("'draw:caption-id' does not point to text:box element.").printStackTrace();
        return null;
    }

    public TitleElement getSVGTitleElement() {
        NodeList nl = xpathService.evalForNodeList(EXP1, (Node)this);
        if (nl != null && nl.getLength() == 1) {
            return (TitleElement)nl.item(0);
        }
        if (nl != null && nl.getLength() > 1) {
            new ODFException("drawing object has more than one svg:title elements.").printStackTrace();
        }
        return null;
    }

    public DescElement getSVGDescElement() {
        NodeList nl = xpathService.evalForNodeList(EXP2, (Node)this);
        if (nl != null && nl.getLength() == 1) {
            return (DescElement)nl.item(0);
        }
        if (nl != null && nl.getLength() > 1) {
            new ODFException("drawing object has more than one svg:desc elements.").printStackTrace();
        }
        return null;
    }
}

