/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaticTABLERenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context ctx, String url, MessageCollection mc) {
        int rcnt = StaticTABLERenderer.getRowsCount(element);
        int ccnt = StaticTABLERenderer.getColumnsCount(element);
        String result = OutLoud.buildResultString(mc, url, element, "in", null, "name=num1", Integer.toString(ccnt), "name=num2", Integer.toString(rcnt));
        this.setContextIn(element, ctx);
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, ctx, true));
    }

    private static int getRowsCount(Element element) {
        Element startNode;
        Node node = startNode = element;
        int rowscount = 0;
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("tr")) {
                ++rowscount;
            }
            node = StaticTABLERenderer.goNext(node, startNode);
        }
        return rowscount;
    }

    private static int getColumnsCount(Element element) {
        Element startNode;
        Node node = startNode = element;
        int ccnt = 0;
        int maxcnt = 0;
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("tr")) {
                if (maxcnt < ccnt) {
                    maxcnt = ccnt;
                }
                ccnt = 0;
            }
            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("td")) {
                ++ccnt;
            }
            if ((node = StaticTABLERenderer.goNext(node, startNode)) != null || maxcnt >= ccnt) continue;
            maxcnt = ccnt;
        }
        return maxcnt;
    }

    private static Node goNext(Node node, Node sNode) {
        if (node == null) {
            return null;
        }
        if (node.hasChildNodes()) {
            node = node.getFirstChild();
        } else if (node.getNextSibling() != null) {
            node = node.getNextSibling();
        } else {
            while (true) {
                Node pnode;
                if ((pnode = node.getParentNode()) == null || pnode == sNode) {
                    node = null;
                    break;
                }
                node = pnode.getNextSibling();
                if (node != null) break;
                node = pnode;
            }
        }
        return node;
    }

    public PacketCollection getPacketCollectionOut(Element element, Context ctx, String url, MessageCollection mc) {
        this.setContextOut(element, ctx);
        String result = OutLoud.buildResultString(mc, url, element, "out", null);
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, ctx, true));
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setStartSelect(true);
        curContext.setGoChild(true);
        curContext.setLineDelimiter(true);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setStartSelect(true);
        curContext.setGoChild(true);
        curContext.setLineDelimiter(true);
    }
}

