/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticINPUTRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context curContext, String url, MessageCollection mc) {
        try {
            this.setContextIn(element, curContext);
            NamedNodeMap attrs = element.getAttributes();
            String type = null;
            String result = null;
            Node typeNode = attrs.getNamedItem("type");
            if (typeNode != null) {
                type = typeNode.getNodeValue();
                if (type.length() > 0) {
                    if (type.equals("image")) {
                        result = this.inputTypeImage(element, attrs, mc, url);
                    } else if (type.equals("text")) {
                        result = this.inputTypeText(element, attrs, mc, url);
                    } else if (type.equals("submit")) {
                        result = this.inputTypeSubmit(element, attrs, mc, url);
                    } else if (type.equals("reset")) {
                        result = this.inputTypeReset(element, attrs, mc, url);
                    } else if (type.equals("button")) {
                        result = this.inputTypeButton(element, attrs, mc, url);
                    } else if (type.equals("password")) {
                        result = this.inputTypePassword(element, attrs, mc, url);
                    } else if (type.equals("checkbox")) {
                        result = this.inputTypeCheckbox(element, attrs, mc, url);
                    } else if (type.equals("radio")) {
                        result = this.inputTypeRadio(element, attrs, mc, url);
                    } else if (type.equals("file")) {
                        result = this.inputTypeFile(element, attrs, mc, url);
                    } else if (type.equals("hidden")) {
                        result = this.inputTypeHidden(element, attrs, mc, url);
                    }
                }
            } else {
                result = this.inputTypeText(element, attrs, mc, url);
            }
            if (OutLoud.jwat_mode == 2) {
                curContext.setLineDelimiter(true);
                curContext.setStartSelect(true);
            }
            if (result != null) {
                result = result.trim();
                return new PacketCollection(new Packet(element, result, curContext, true));
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private String inputTypeImage(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = null;
        String value = null;
        Node valueNode = attrs.getNamedItem("alt");
        if (valueNode != null && (value = valueNode.getNodeValue()) != null && value.length() > 0 && (result = OutLoud.buildResultString(mc, url, element, "image", "hasstr", "name=str1", value)) == null) {
            result = "[" + value + ": Image button.]";
        }
        if (value == null) {
            valueNode = attrs.getNamedItem("src");
            if (valueNode != null) {
                value = valueNode.getNodeValue();
                int scount = 0;
                int j = 0;
                while (j < value.length()) {
                    if (value.charAt(j) == '/') {
                        ++scount;
                    }
                    ++j;
                }
                if (scount >= 2) {
                    j = 0;
                    int cnt = 0;
                    while (j < value.length()) {
                        if (value.charAt(j) == '/' && ++cnt == scount - 1) {
                            value = value.substring(j + 1, value.length());
                        }
                        ++j;
                    }
                }
            }
            if (value != null && value.length() > 0) {
                result = OutLoud.buildResultString(mc, url, element, "image", "hasstr", "name=str", value);
                if (result == null) {
                    result = "[" + value + ": Image button.]";
                }
            } else {
                result = OutLoud.buildResultString(mc, url, element, "image", "nostr");
                if (result == null) {
                    result = "[Image button.]";
                }
            }
        }
        return result;
    }

    private String inputTypeText(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = OutLoud.buildResultString(mc, url, element, "text", null);
        if (result == null) {
            result = "[Text.]";
        }
        return result;
    }

    private String inputTypeSubmit(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = null;
        String value = null;
        Node valueNode = attrs.getNamedItem("VALUE");
        if (valueNode != null) {
            value = valueNode.getNodeValue();
        }
        if (value != null && value.length() > 0) {
            result = OutLoud.buildResultString(mc, url, element, "submit", "hasstr", "name=str1", value);
            if (result == null) {
                result = "[" + value + ": Submit button.]";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "submit", "nostr");
            if (result == null) {
                result = "[Submit button.]";
            }
        }
        return result;
    }

    private String inputTypeReset(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = null;
        String value = null;
        Node valueNode = attrs.getNamedItem("VALUE");
        if (valueNode != null) {
            value = valueNode.getNodeValue();
        }
        if (value != null && value.length() > 0) {
            result = OutLoud.buildResultString(mc, url, element, "reset", "hasstr", "name=str1", value);
            if (result == null) {
                result = "[" + value + ": Reset button.]";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "reset", "nostr");
            if (result == null) {
                result = "[Reset button.]";
            }
        }
        return result;
    }

    private String inputTypeButton(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = null;
        String value = null;
        Node valueNode = attrs.getNamedItem("VALUE");
        if (valueNode != null) {
            value = valueNode.getNodeValue();
        }
        if (value != null && value.length() > 0) {
            result = OutLoud.buildResultString(mc, url, element, "button", "hasstr", "name=str1", value);
            if (result == null) {
                result = "[" + value + ": Button.]";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "button", "nostr");
            if (result == null) {
                result = "[Button.]";
            }
        }
        return result;
    }

    private String inputTypePassword(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = OutLoud.buildResultString(mc, url, element, "password", null);
        if (result == null) {
            result = "[Password.]";
        }
        return result;
    }

    private String inputTypeCheckbox(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = null;
        Node cnode = attrs.getNamedItem("checked");
        if (cnode == null) {
            result = OutLoud.buildResultString(mc, url, element, "checkbox", "off");
            if (result == null) {
                result = "[Not Checked.]";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "checkbox", "on");
            if (result == null) {
                result = "[Checked.]";
            }
        }
        return result;
    }

    private String inputTypeRadio(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = null;
        Node cnode = attrs.getNamedItem("checked");
        if (cnode == null) {
            result = OutLoud.buildResultString(mc, url, element, "radio", "off");
            if (result == null) {
                result = "[Not Pressed.]";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "radio", "on");
            if (result == null) {
                result = "[Pressed.]";
            }
        }
        return result;
    }

    private String inputTypeFile(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        String result = OutLoud.buildResultString(mc, url, element, "file", null);
        if (result == null) {
            result = "[Browse button.]";
        }
        return result;
    }

    private String inputTypeHidden(Element element, NamedNodeMap attrs, MessageCollection mc, String url) {
        return null;
    }

    public PacketCollection getPacketCollectionOut(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextOut(element, curContext);
        return null;
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setGoChild(true);
        try {
            NamedNodeMap attrs = element.getAttributes();
            String type = null;
            Node typeNode = attrs.getNamedItem("type");
            if (typeNode != null) {
                type = typeNode.getNodeValue();
                if (type.length() > 0) {
                    if (type.equals("submit") || type.equals("reset")) {
                        curContext.setLineDelimiter(true);
                    } else {
                        curContext.setLineDelimiter(false);
                    }
                } else {
                    curContext.setLineDelimiter(false);
                }
            } else {
                curContext.setLineDelimiter(false);
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        curContext.setLinkTag(true);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setGoChild(true);
        curContext.setLineDelimiter(true);
        curContext.setLinkTag(false);
    }
}

