/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.blind.odfbyhtml.ui;

import org.eclipse.actf.visualization.ui.IVisualizationPerspective;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewRegistry;

public class ODFPerspective
implements IPerspectiveFactory,
IVisualizationPerspective {
    private static final String RESOURCE_FOLDER = "actf.odf.resource.folder";
    private static final String VIEW_FOLDER = "actf.odf.visualization.view.folder";
    private static final String REPORT_FOLDER = "actf.odf.report.view.folder";
    private static final String RESOURCE_NAVIGATOR = "org.eclipse.ui.views.ResourceNavigator";
    private static final String PACKAGE_EXPLORER = "org.eclipse.jdt.ui.PackageExplorer";

    public void createInitialLayout(IPageLayout layout) {
        IFolderLayout resourceFolder;
        layout.setEditorAreaVisible(true);
        String editorArea = layout.getEditorArea();
        IWorkbench workbench = PlatformUI.getWorkbench();
        boolean hasResourceNavigator = false;
        boolean hasPackageExplorer = false;
        if (workbench != null) {
            IViewRegistry viewReg = workbench.getViewRegistry();
            hasResourceNavigator = viewReg.find(RESOURCE_NAVIGATOR) != null;
            boolean bl = hasPackageExplorer = viewReg.find(PACKAGE_EXPLORER) != null;
        }
        if (hasResourceNavigator) {
            resourceFolder = layout.createFolder(RESOURCE_FOLDER, 1, 0.2f, editorArea);
            resourceFolder.addView(RESOURCE_NAVIGATOR);
            if (hasPackageExplorer) {
                resourceFolder.addPlaceholder(PACKAGE_EXPLORER);
            }
        } else if (hasPackageExplorer) {
            resourceFolder = layout.createFolder(RESOURCE_FOLDER, 1, 0.2f, editorArea);
            resourceFolder.addView(PACKAGE_EXPLORER);
        }
        IFolderLayout reportFolder = layout.createFolder(REPORT_FOLDER, 4, 0.7f, editorArea);
        reportFolder.addView("org.eclipse.actf.visualization.ui.report.views.SummaryReportView");
        reportFolder.addView("org.eclipse.actf.visualization.ui.report.views.DetailedReportView");
        IFolderLayout viewFolder = layout.createFolder(VIEW_FOLDER, 2, 0.5f, editorArea);
        viewFolder.addView("org.eclipse.actf.visualization.blind.ui.views.BlindView");
        viewFolder.addView("org.eclipse.actf.visualization.lowvision.ui.views.LowVisionView");
        viewFolder.addView("org.eclipse.actf.visualization.presentation.ui.views.RoomView");
    }
}

