/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.eval;

import java.util.List;
import org.eclipse.actf.ui.util.HighlightStringListener;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryEvaluationLV {
    private IProblemItemImage[] _problems = new IProblemItemImage[0];

    public static HighlightStringListener getHighLightStringListener() {
        HighlightStringListener hlsl = new HighlightStringListener();
        Color blue = Display.getDefault().getSystemColor(9);
        Color red = Display.getDefault().getSystemColor(3);
        if (Display.getDefault().getHighContrast()) {
            blue = null;
            red = null;
        }
        hlsl.addTarget(Messages.EvalLV_no_color_difficult_distinguish, blue, 1);
        hlsl.addTarget(Messages.EvalLV_font_might_enough_to_read, blue, 1);
        hlsl.addTarget(Messages.EvalLV_color_difficult_distinguish, red, 1);
        hlsl.addTarget(Messages.EvalLV_color_might_difficult_distinguish, red, 1);
        hlsl.addTarget(Messages.EvalLV_font_too_small_to_read, red, 1);
        hlsl.addTarget(Messages.EvalLV_font_might_too_small_to_read, red, 1);
        hlsl.addTarget(Messages.EvalLV_page_have_fixed_font, red, 1);
        hlsl.addTarget(Messages.EvalLV_0, null, 1);
        return hlsl;
    }

    public SummaryEvaluationLV(List<IProblemItem> problemList) {
        try {
            this._problems = new IProblemItemImage[problemList.size()];
            problemList.toArray(this._problems);
        }
        catch (Exception exception) {
            this._problems = new IProblemItemImage[0];
        }
    }

    public static String notSupported() {
        return Messages.EvalLV_0;
    }

    public String getOverview() {
        StringBuffer tmpSB = new StringBuffer(512);
        int[] problemCount = new int[11];
        int[] severeCount = new int[11];
        int i = 0;
        while (i < this._problems.length) {
            IProblemItemImage curProblem = this._problems[i];
            int n = curProblem.getSubType();
            problemCount[n] = problemCount[n] + 1;
            if (curProblem.getSeverityLV() > 49) {
                int n2 = curProblem.getSubType();
                severeCount[n2] = severeCount[n2] + 1;
            }
            ++i;
        }
        if (problemCount[1] > 0 || problemCount[3] > 0) {
            if (severeCount[1] > 0 || severeCount[3] > 0) {
                tmpSB.append(String.valueOf(Messages.EvalLV_color_difficult_distinguish) + FileUtils.LINE_SEP);
            } else {
                tmpSB.append(String.valueOf(Messages.EvalLV_color_might_difficult_distinguish) + FileUtils.LINE_SEP);
            }
            tmpSB.append(String.valueOf(Messages.EvalLV_click_detailed_report) + FileUtils.LINE_SEP);
            tmpSB.append(FileUtils.LINE_SEP);
            if (problemCount[1] > 0) {
                tmpSB.append(String.valueOf(Messages.EvalLV_text_color_combination) + " " + problemCount[1] + FileUtils.LINE_SEP);
            }
            if (problemCount[3] > 0) {
                tmpSB.append(String.valueOf(Messages.EvalLV_img_color_combination) + " " + problemCount[3] + FileUtils.LINE_SEP);
            }
        } else {
            tmpSB.append(String.valueOf(Messages.EvalLV_no_color_difficult_distinguish) + FileUtils.LINE_SEP);
        }
        tmpSB.append(FileUtils.LINE_SEP);
        if (problemCount[5] > 0 || problemCount[6] > 0) {
            if (severeCount[5] > 0 || severeCount[6] > 0) {
                tmpSB.append(String.valueOf(Messages.EvalLV_font_too_small_to_read) + FileUtils.LINE_SEP);
            } else {
                tmpSB.append(String.valueOf(Messages.EvalLV_font_might_too_small_to_read) + FileUtils.LINE_SEP);
            }
            tmpSB.append(String.valueOf(Messages.EvalLV_click_detailed_report) + FileUtils.LINE_SEP);
            tmpSB.append(FileUtils.LINE_SEP);
            if (problemCount[5] > 0) {
                tmpSB.append(String.valueOf(Messages.EvalLV_font_too_small) + " " + problemCount[5]);
            }
            if (problemCount[6] > 0) {
                tmpSB.append(String.valueOf(Messages.EvalLV_font_too_small_fixed) + " " + problemCount[6]);
            }
        } else if (problemCount[4] > 0) {
            tmpSB.append(String.valueOf(Messages.EvalLV_page_have_fixed_font) + FileUtils.LINE_SEP);
            tmpSB.append(FileUtils.LINE_SEP);
            tmpSB.append(String.valueOf(Messages.EvalLV_font_fixed) + " " + problemCount[4]);
        } else {
            tmpSB.append(String.valueOf(Messages.EvalLV_font_might_enough_to_read) + FileUtils.LINE_SEP);
        }
        return tmpSB.toString();
    }
}

