/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util.html2view;

import java.util.Vector;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLine2Id {
    private Html2ViewMapData[] data;
    private int size;
    private boolean is1base;

    public HtmlLine2Id(Vector<Html2ViewMapData> mapV) {
        this(mapV, true);
    }

    public HtmlLine2Id(Vector<Html2ViewMapData> mapV, boolean is1base) {
        this.is1base = is1base;
        try {
            this.size = mapV.size();
            this.data = new Html2ViewMapData[this.size + 1];
            int i = 0;
            while (i < this.size) {
                this.data[i] = mapV.get(i);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<Integer> getId(int target) {
        int line = target;
        if (this.is1base) {
            --line;
        }
        int firstId = this.search(0, this.size - 1, line);
        Vector<Integer> resultV = new Vector<Integer>();
        if (firstId > -1) {
            while (firstId < this.size && this.data[firstId].getStartLine() == line) {
                resultV.add(new Integer(firstId));
                ++firstId;
            }
        }
        return resultV;
    }

    private int search(int start, int end, int target) {
        if (this.data[start].getStartLine() < target && this.data[end].getStartLine() > target) {
            int tmp = (start + end) / 2;
            if (this.data[tmp].getStartLine() > target) {
                return this.search(start, tmp, target);
            }
            if (start == tmp) {
                return -1;
            }
            return this.search(tmp, end, target);
        }
        if (this.data[end].getStartLine() == target) {
            while (--end >= 0 && this.data[end].getStartLine() == target) {
            }
            return ++end;
        }
        if (this.data[start].getStartLine() == target) {
            return start;
        }
        return -1;
    }
}

