/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.tweaklets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;

public class TabBehaviourMRU
extends TabBehaviour {
    public boolean alwaysShowPinAction() {
        return false;
    }

    public IEditorReference findReusableEditor(WorkbenchPage page) {
        IEditorPart editor;
        boolean reuse = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!reuse) {
            return null;
        }
        IEditorReference[] editors = page.getSortedEditors();
        int length = editors.length;
        if (length < page.getEditorReuseThreshold()) {
            return null;
        }
        if (length > page.getEditorReuseThreshold()) {
            ArrayList<IEditorReference> refs = new ArrayList<IEditorReference>();
            ArrayList<IEditorReference> keep = new ArrayList<IEditorReference>(Arrays.asList(editors));
            int extra = length - page.getEditorReuseThreshold();
            int i = 0;
            while (i < editors.length) {
                if (extra == 0) break;
                if (!editors[i].isPinned() && !editors[i].isDirty()) {
                    refs.add(editors[i]);
                    --extra;
                }
                ++i;
            }
            for (IEditorReference ref : refs) {
                page.closeEditor(ref, false);
                keep.remove(ref);
            }
            editors = keep.toArray(new IEditorReference[keep.size()]);
        }
        IEditorReference dirtyEditor = null;
        int i = editors.length - 1;
        while (i > -1) {
            IEditorReference editor2 = editors[i];
            if (!editor2.isPinned()) {
                if (editor2.isDirty()) {
                    if (dirtyEditor == null) {
                        dirtyEditor = editor2;
                    }
                } else {
                    return editor2;
                }
            }
            --i;
        }
        if (dirtyEditor == null) {
            return null;
        }
        boolean reuseDirty = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_DIRTY_EDITORS");
        if (!reuseDirty) {
            return null;
        }
        MessageDialog dialog = new MessageDialog(page.getWorkbenchWindow().getShell(), WorkbenchMessages.EditorManager_reuseEditorDialogTitle, null, NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)dirtyEditor.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, WorkbenchMessages.EditorManager_openNewEditorLabel}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        int result = dialog.open();
        if (result == 0 ? !page.saveEditor(editor = dirtyEditor.getEditor(true), false) : result == 2 || result == -1) {
            return null;
        }
        return dirtyEditor;
    }

    public IEditorReference reuseInternalEditor(WorkbenchPage page, Object manager, Object editorPresentation, EditorDescriptor desc, IEditorInput input, IEditorReference reusableEditorRef) {
        E4Util.unsupported("reuseInternalEditor: we reuse nothing");
        return reusableEditorRef;
    }
}

