/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editor.actions;

import java.util.Map;
import org.eclipse.actf.model.internal.ui.FavoritesChangeEvent;
import org.eclipse.actf.model.internal.ui.FavoritesUtil;
import org.eclipse.actf.model.internal.ui.editor.actions.FavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.dialogs.FavoritesAddDialog;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFavoritesAction
extends FavoritesAction {
    public static final String ID = AddFavoritesAction.class.getName();
    private IWorkbenchWindow _window;

    public AddFavoritesAction(IWorkbenchWindow window, Map<String, String> favoritesMap) {
        this._window = window;
        this.setId(ID);
        this.setText(ModelServiceMessages.MenuConst_AddFavorites);
    }

    public void run() {
        if (this._window != null) {
            IModelService modelService = ModelServiceUtils.getActiveModelService();
            if (modelService == null) {
                return;
            }
            String title = modelService.getURL();
            if (modelService instanceof IWebBrowserACTF) {
                title = ((IWebBrowserACTF)modelService).getLocationName();
            }
            Map<String, String> tmpMap = FavoritesUtil.getFavoritesMap();
            FavoritesAddDialog addDialog = new FavoritesAddDialog(this._window.getShell(), tmpMap, title);
            int ret = addDialog.open();
            if (ret == 0) {
                String url = modelService.getURL();
                tmpMap.put(addDialog.getName(), url);
                FavoritesUtil.saveFavoritesMap(tmpMap);
                FavoritesChangeEvent fce = new FavoritesChangeEvent((Object)this, tmpMap);
                this.fireFavoritesChanged(fce);
            }
        }
    }
}

