/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.srcviewer;

import java.io.File;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.ReportPlugin;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.SrcViewer;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SrcViewerForPT {
    private static SrcViewerForPT INSTANCE = null;
    private static SrcViewer _srcViewer;
    private static Shell _srcViewerShell;
    private Shell _shell = null;
    private boolean srcChanged;
    private File curTarget;

    private SrcViewerForPT(Shell shell) {
        this._shell = shell;
        this.initSrcViewer();
    }

    public static SrcViewerForPT initSrcViewerForPT(Shell parent) {
        INSTANCE = new SrcViewerForPT(parent);
        return INSTANCE;
    }

    public static SrcViewerForPT getInstance() {
        return INSTANCE;
    }

    private void initSrcViewer() {
        this.srcChanged = true;
        if (this._shell != null) {
            this._shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent arg0) {
                    if (_srcViewerShell != null && !_srcViewerShell.isDisposed()) {
                        _srcViewerShell.dispose();
                    }
                }
            });
        }
    }

    public void openSrcViewer() {
        if (_srcViewerShell == null || _srcViewerShell.isDisposed()) {
            Display display = this._shell.getDisplay();
            if (display == null) {
                display = Display.getDefault();
            }
            _srcViewerShell = new Shell(display);
            _srcViewerShell.setLayout((Layout)new FillLayout());
            _srcViewerShell.setImage(ReportPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.ui.report", (String)"icons/excla_squ.png").createImage());
            _srcViewerShell.setText(Messages.SrcViewerForPT_0);
            _srcViewer = new SrcViewer((Composite)_srcViewerShell);
            _srcViewerShell.setSize(600, 750);
            _srcViewerShell.setFocus();
            _srcViewerShell.open();
            _srcViewerShell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent arg0) {
                    _srcViewer.closeSearchDlgShell();
                }
            });
            this.srcChanged = true;
        } else if (!_srcViewerShell.isDisposed()) {
            if (_srcViewerShell.getMinimized()) {
                _srcViewerShell.setMinimized(false);
            }
            _srcViewerShell.forceActive();
        }
    }

    public void highlightSrcViewer(HighlightTargetSourceInfo[] sourceInfos, File target) {
        if (_srcViewerShell != null && !_srcViewerShell.isDisposed()) {
            if (this.curTarget != target || this.srcChanged) {
                this.srcChanged = true;
                this.updateSrcViewer(target);
            }
            _srcViewer.clearHighlight();
            int i = 0;
            while (i < sourceInfos.length) {
                HighlightTargetSourceInfo curInfo = sourceInfos[i];
                if (curInfo.getStartColumn() < 0 || curInfo.getEndColumn() < 0) {
                    _srcViewer.highlightLines(curInfo.getStartLine(), curInfo.getEndLine());
                } else {
                    _srcViewer.highlight(curInfo.getStartLine(), curInfo.getStartColumn(), curInfo.getEndLine(), curInfo.getEndColumn());
                }
                ++i;
            }
        }
    }

    public void updateSrcViewer(File target) {
        if (_srcViewerShell != null && !_srcViewerShell.isDisposed() && this.srcChanged) {
            try {
                _srcViewer.openFile(target);
                this.curTarget = target;
            }
            catch (Exception exception) {
                _srcViewer.setText("");
            }
            this.srcChanged = false;
        }
    }

    public void setSrcChanged(boolean srcChanged) {
        this.srcChanged = srcChanged;
    }
}

