/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.TextCounter;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInfoCreator {
    private static final String HEADING_TAGS = "h1|h2|h3|h4|h5|h6";
    private static final String LIST_TAGS = "ul|ol|dl";
    private static final Set<String> BLOCK_TAG_SET = HtmlTagUtil.getBlockElementSet();
    private VisualizeMapDataImpl mapData;
    private TextChecker textChecker;
    private List<IProblemItem> problems;
    private Set<String> invisibleIdSet;
    private TextCounter textCounter;

    public NodeInfoCreator(VisualizeMapDataImpl mapData, TextChecker textChecker, List<IProblemItem> problems, Set<String> invisibleIdSet, ParamBlind paramBlind) {
        this.mapData = mapData;
        this.textChecker = textChecker;
        this.problems = problems;
        this.invisibleIdSet = invisibleIdSet;
        this.textCounter = new TextCounter(paramBlind.iLanguage);
    }

    private String removePeriod(String targetS, Node targetNode) {
        String nodeS;
        if (targetNode != null && ((nodeS = targetNode.getNodeName()).equals("img") || nodeS.equals("applet")) && targetS.endsWith(".]")) {
            targetS = String.valueOf(targetS.substring(0, targetS.lastIndexOf(".]"))) + "]";
        }
        return targetS;
    }

    private boolean isIdRequiredInput(Element el) {
        String type;
        String tagName = el.getNodeName();
        if (tagName.equals("select")) {
            return true;
        }
        if (tagName.equals("textarea")) {
            return true;
        }
        return tagName.equals("input") && (type = el.getAttribute("type").toLowerCase()).length() == 0 | type.equals("text") | type.equals("textarea") | type.equals("radio") | type.equals("checkbox");
    }

    public void prepareNodeInfo(IPacketCollection pc) {
        int size = 0;
        if (pc == null) {
            return;
        }
        size = pc.size();
        int totalWords = 0;
        int lineNumber = 0;
        int previousLineNumber = 0;
        String prevText = null;
        IPacket prevPacket = null;
        int it = 0;
        while (it < size) {
            Element el;
            Attr attrNode;
            String nodeName;
            IPacket p = (IPacket)pc.get(it);
            Node node = p.getNode();
            if (node.getNodeType() != 1 || !(!(nodeName = node.getNodeName()).equals("option") ? nodeName.equals("area") || nodeName.equals("map") : (attrNode = (el = (Element)node).getAttributeNode("selected")) == null)) {
                VisualizationNodeInfo already;
                String curText = p.getText();
                if (curText != null && curText.length() > 0) {
                    String nodeName2;
                    if (this.textChecker.isSeparatedJapaneseChars(curText) && !(nodeName2 = p.getNode().getNodeName()).matches("img|input|area")) {
                        BlindProblem prob = new BlindProblem(15, curText);
                        prob.setNode(p.getNode());
                        prob.setTargetNode(this.mapData.getOrigNode(p.getNode()));
                        this.problems.add(prob);
                    }
                    if (prevPacket != null && p.getContext().isInsideAnchor() == prevPacket.getContext().isInsideAnchor()) {
                        Node curNode = p.getNode();
                        Node prevNode = prevPacket.getNode();
                        if (!curNode.getNodeName().equals("input") && this.textChecker.isRedundantText(prevText, curText) && !HtmlTagUtil.hasAncestor((Node)curNode, (String)"noscript") && !HtmlTagUtil.hasAncestor((Node)prevNode, (String)"noscript")) {
                            prevText = this.removePeriod(prevText, prevNode);
                            curText = this.removePeriod(curText, curNode);
                            BlindProblem prob = new BlindProblem(9, "\"" + prevText + "\" & \"" + curText + "\"");
                            prob.setNode(prevNode);
                            prob.addNode(curNode);
                            if (prevNode.getNodeName().equals("img")) {
                                prob.setTargetNode(this.mapData.getOrigNode(prevNode));
                                prob.setTargetStringForExport(prevText);
                                this.problems.add(prob);
                            } else if (curNode.getNodeName().equals("img")) {
                                prob.setTargetNode(this.mapData.getOrigNode(curNode));
                                prob.setTargetStringForExport(curText);
                                this.problems.add(prob);
                            }
                        }
                    }
                    prevText = curText;
                    prevPacket = p;
                }
                if ((already = this.mapData.getNodeInfo(p.getNode())) == null) {
                    VisualizationNodeInfo info = new VisualizationNodeInfo();
                    info.setPacket(p);
                    int words = this.textCounter.getWordCount(p.getText());
                    boolean isVisible = true;
                    Node curNode = p.getNode();
                    while (curNode != null) {
                        String nodeName3 = curNode.getNodeName();
                        if (curNode.getNodeType() == 1) {
                            Element tmpE = (Element)curNode;
                            if (tmpE.hasAttribute("accesskey")) {
                                info.setAccesskey(true);
                            }
                            if (this.invisibleIdSet.contains(tmpE.getAttribute("id"))) {
                                info.setInvisible(true);
                                isVisible = false;
                            }
                        }
                        if (nodeName3.matches(HEADING_TAGS)) {
                            info.setHeading(true);
                            info.appendComment("Heading: " + nodeName3 + ".");
                        } else if (nodeName3.equals("th")) {
                            info.setTableHeader(true);
                            info.appendComment("Table header.");
                        } else if (nodeName3.equals("label")) {
                            info.setLabel(true);
                            info.appendComment("Label for '" + ((Element)curNode).getAttribute("for") + "'. ");
                        }
                        if (nodeName3.equals("body")) break;
                        curNode = curNode.getParentNode();
                    }
                    if (isVisible) {
                        info.setWords(words);
                        info.setTotalWords(totalWords);
                        info.setOrgTotalWords(totalWords);
                        totalWords += words;
                        if (words > 0) {
                            ++lineNumber;
                        }
                        info.setTotalLines(previousLineNumber);
                        info.setOrgTotalLines(previousLineNumber);
                        info.setLines(lineNumber - previousLineNumber);
                        previousLineNumber = lineNumber;
                    } else {
                        info.setWords(0);
                        info.setTotalWords(totalWords);
                        info.setOrgTotalWords(totalWords);
                        info.setTotalLines(previousLineNumber);
                        info.setOrgTotalLines(previousLineNumber);
                        info.setLines(0);
                    }
                    info.setPacketId(it);
                    this.mapData.addNodeInfoMapping(p.getNode(), info);
                }
            }
            ++it;
        }
    }

    public void createAdditionalNodeInfo(Document doc) {
        int origTotalWords = 0;
        int origTotalLines = 0;
        Map<String, String> mapTextMap = VisualizeMapUtil.createMapTextMap(doc);
        NodeList bodyNl = doc.getElementsByTagName("body");
        if (bodyNl.getLength() > 0) {
            Element bodyEl;
            if (bodyNl.getLength() > 1) {
                System.out.println("multiple body");
            }
            if ((bodyEl = (Element)bodyNl.item(0)).hasChildNodes()) {
                Stack<Node> stack = new Stack<Node>();
                stack.push(bodyEl);
                Node curNode = bodyEl.getFirstChild();
                VisualizationNodeInfo lastInfo = null;
                int counter = 0;
                int listCount = 0;
                while (curNode != null && stack.size() > 0) {
                    String curNodeName = curNode.getNodeName();
                    VisualizationNodeInfo curInfo = this.mapData.getNodeInfo(curNode);
                    if (curNode.getNodeType() == 3) {
                        if (curInfo != null) {
                            curInfo.setId(counter);
                            this.mapData.addNodeInfoIntoList(curInfo);
                            ++counter;
                            lastInfo = curInfo;
                        }
                    } else if (curNode.getNodeType() == 1) {
                        String map;
                        if (curInfo != null) {
                            curInfo.setId(counter);
                            this.mapData.addNodeInfoIntoList(curInfo);
                            ++counter;
                            lastInfo = curInfo;
                        } else {
                            try {
                                curInfo = new VisualizationNodeInfo(lastInfo);
                                curInfo.setWords(0);
                                curInfo.setLines(0);
                                curInfo.setId(counter);
                                curInfo.setNode(curNode);
                                ++counter;
                                this.mapData.addNodeInfoIntoList(curInfo);
                                this.mapData.addNodeInfoMapping(curNode, curInfo);
                            }
                            catch (NullPointerException npe) {
                                npe.printStackTrace();
                            }
                        }
                        if (curNodeName.equals("img") && (map = ((Element)curNode).getAttribute("usemap")) != null && map.length() > 0) {
                            int words = curInfo.getWords();
                            String curText = mapTextMap.get(map.toLowerCase().substring(1));
                            int add = this.textCounter.getWordCount(curText);
                            curInfo.setWords(words + add);
                            curInfo.setLines(curInfo.getLines() + 1);
                        }
                    }
                    if (curInfo != null) {
                        curInfo.setTotalWords(origTotalWords);
                        curInfo.setOrgTotalWords(origTotalWords);
                        curInfo.setTotalLines(origTotalLines);
                        curInfo.setOrgTotalLines(origTotalLines);
                        origTotalWords += curInfo.getWords();
                        origTotalLines += curInfo.getLines();
                        if (listCount > 0) {
                            curInfo.setSequence(true);
                        }
                        if (BLOCK_TAG_SET.contains(curNodeName)) {
                            curInfo.setBlockElement(true);
                        }
                        if (curNode.getNodeType() == 1 && this.isIdRequiredInput((Element)curNode)) {
                            curInfo.setIdRequiredInput(true);
                            curInfo.appendComment("Input with id, '" + ((Element)curNode).getAttribute("id") + "'. ");
                        }
                        this.mapData.addNodeIdMapping(curInfo.getNode(), new Integer(curInfo.getId()));
                    }
                    boolean isListTag = curNodeName.matches(LIST_TAGS);
                    if (curNode.hasChildNodes()) {
                        if (isListTag) {
                            ++listCount;
                        }
                        stack.push(curNode);
                        curNode = curNode.getFirstChild();
                        continue;
                    }
                    if (curNode.getNextSibling() != null) {
                        if (isListTag) {
                            --listCount;
                        }
                        curNode = curNode.getNextSibling();
                        continue;
                    }
                    if (isListTag) {
                        --listCount;
                    }
                    curNode = null;
                    while (curNode == null && stack.size() > 0) {
                        curNode = (Node)stack.pop();
                        curNodeName = curNode.getNodeName();
                        if (isListTag) {
                            --listCount;
                        }
                        curNode = curNode.getNextSibling();
                    }
                }
            }
        }
    }
}

