/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualizeReportUtil {
    public static void createReport(File targetFile, PageEvaluation pageEval) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            Document document = domImpl.createDocument("", "html", null);
            Element rootN = document.getDocumentElement();
            Element head = document.createElement("head");
            Element meta = document.createElement("meta");
            meta.setAttribute("http-equiv", "Content-type");
            meta.setAttribute("content", "text/html; charset=UTF-8");
            head.appendChild(meta);
            Element title = document.createElement("title");
            title.appendChild(document.createTextNode("Overall rating"));
            head.appendChild(title);
            rootN.appendChild(head);
            Element body = document.createElement("body");
            rootN.appendChild(body);
            Element div = document.createElement("div");
            Element starImg = document.createElement("img");
            starImg.setAttribute("src", "img/" + pageEval.getRatingIcon());
            starImg.setAttribute("alt", "");
            div.appendChild(starImg);
            Element b = document.createElement("b");
            b.appendChild(document.createTextNode(" " + pageEval.getOverallRating()));
            div.appendChild(b);
            body.appendChild(div);
            int count = 0;
            boolean[] enabledMetrics = GuidelineHolder.getInstance().getMatchedMetrics();
            int i = 0;
            while (i < enabledMetrics.length) {
                if (enabledMetrics[i]) {
                    ++count;
                }
                ++i;
            }
            if (count > 2) {
                Element img = document.createElement("img");
                img.setAttribute("src", "./pagerating.png");
                img.setAttribute("alt", "");
                body.appendChild(img);
            }
            body.appendChild(document.createElement("hr"));
            VisualizeReportUtil.appendRatingTable(pageEval.getAllResult(), document, body);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            FileOutputStream os = new FileOutputStream(targetFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
            StreamResult result = new StreamResult(osw);
            transformer.transform(source, result);
            osw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void appendRatingTableAndTitle(PageEvaluation pageEval, String imageDir, Document document, Node target) {
        String[] ratingStr = pageEval.getAllResult();
        Element p = document.createElement("div");
        Element img = document.createElement("img");
        img.setAttribute("src", String.valueOf(imageDir) + pageEval.getRatingIcon());
        img.setAttribute("alt", "");
        p.appendChild(img);
        Element b = document.createElement("b");
        b.appendChild(document.createTextNode(String.valueOf(ratingStr[0]) + ": " + ratingStr[1]));
        p.appendChild(b);
        target.appendChild(p);
        VisualizeReportUtil.appendRatingTable(ratingStr, document, target);
    }

    private static void appendRatingTable(String[] ratingStr, Document document, Node target) {
        Element table = document.createElement("table");
        table.setAttribute("border", "1");
        Element tr = document.createElement("tr");
        Element th = document.createElement("th");
        th.appendChild(document.createTextNode("evaluation"));
        tr.appendChild(th);
        th = document.createElement("th");
        th.appendChild(document.createTextNode("score"));
        tr.appendChild(th);
        table.appendChild(tr);
        int size = ratingStr.length / 2;
        int i = 1;
        while (i < size) {
            tr = document.createElement("tr");
            Element td = document.createElement("td");
            td.appendChild(document.createTextNode(ratingStr[i * 2]));
            tr.appendChild(td);
            td = document.createElement("td");
            td.appendChild(document.createTextNode(ratingStr[i * 2 + 1]));
            tr.appendChild(td);
            table.appendChild(tr);
            ++i;
        }
        target.appendChild(table);
    }

    public static void visualizeError(Document resultDoc, IProblemItem problem) {
        Element frameElem;
        String idS;
        Element imageElem = (Element)problem.getTargetNode();
        if (imageElem != null && (idS = (frameElem = (Element)imageElem.getParentNode()).getAttribute("eclipse-actf-id")).length() > 0) {
            Integer idObj = new Integer(idS);
            NodeList nl = XPathServiceFactory.newService().evalPathForNodeList("//*[@eclipse-actf-id='" + idObj + "']/span", (Node)resultDoc.getDocumentElement());
            if (nl != null && nl.getLength() == 1) {
                Element frameElemResultDoc = (Element)nl.item(0);
                Element img = VisualizeReportUtil.createErrorImageElement(frameElemResultDoc, problem, idObj);
                frameElemResultDoc.appendChild(img);
            }
        }
    }

    private static Element createErrorImageElement(Node target, IProblemItem prob, Integer idObj) {
        Element img = target.getOwnerDocument().createElement("img");
        img.setAttribute("alt", "error");
        img.setAttribute("title", prob.getDescription());
        img.setAttribute("onmouseover", "updateBaloon('id" + idObj + "');");
        img.setAttribute("src", "img/" + VisualizeEngine.ERROR_ICON_NAME);
        return img;
    }
}

