/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.PopupMenu;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.internal.engines.blind.html.Messages;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationAttributeInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementViewerJFace {
    private static final String NULL_STRING = "";
    private IHighlightElementListener prb;
    private int[] sortModeArray;
    private Composite elementViewerComposite;
    private TableViewer viewer;
    private TableColumn categoryCol;
    private TableColumn descCol;
    private static final String COL_CATEGORY = "Category";
    private static final String COL_ID_STRING = "Value";
    private static final String COL_TAG_NAME = "Tag Name";
    private static final String COL_DESCRIPTION = "Description";
    private String strHelpUrl;

    public ElementViewerJFace(Composite parent, IHighlightElementListener _prb) {
        this.prb = _prb;
        this.elementViewerComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.elementViewerComposite.setLayout((Layout)gridLayout);
        this.elementViewerComposite.setLayoutData((Object)new GridData(1808));
        final Table table = new Table(this.elementViewerComposite, 68354);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.sortModeArray = new int[4];
        this.categoryCol = new TableColumn(table, 16384);
        this.categoryCol.setText(COL_CATEGORY);
        this.sortModeArray[0] = 0;
        TableColumn idCol = new TableColumn(table, 16384);
        idCol.setText(COL_ID_STRING);
        idCol.setWidth(150);
        this.sortModeArray[1] = 0;
        TableColumn tagCol = new TableColumn(table, 16384);
        tagCol.setText(COL_TAG_NAME);
        tagCol.setWidth(100);
        this.sortModeArray[2] = 0;
        this.descCol = new TableColumn(table, 16384);
        this.descCol.setText(COL_DESCRIPTION);
        this.sortModeArray[3] = 0;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (arg0.stateMask == 0x200000 && table.getSelectionIndex() >= 0) {
                    ElementViewerJFace.this.openPopupMenu();
                }
            }
        });
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ArrayList<VisualizationAttributeInfo> list = new ArrayList<VisualizationAttributeInfo>();
                for (Object tmpO : (IStructuredSelection)arg0.getSelection()) {
                    if (!(tmpO instanceof VisualizationAttributeInfo)) continue;
                    list.add((VisualizationAttributeInfo)tmpO);
                }
                if (list.size() > 0) {
                    ElementViewerJFace.this.viewerSelected(list);
                }
            }
        });
        this.categoryCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ElementViewerJFace.this.toggleCurrentSortMode(0);
                if (ElementViewerJFace.this.sortModeArray[0] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer iviewer, Object e1, Object e2) {
                            int iRes;
                            if (e1 == null) {
                                iRes = -1;
                            } else if (e2 == null) {
                                iRes = 1;
                            } else {
                                String str1 = ((VisualizationAttributeInfo)e1).getCategory();
                                String str2 = ((VisualizationAttributeInfo)e2).getCategory();
                                if (str1.equals(ElementViewerJFace.NULL_STRING)) {
                                    return 1;
                                }
                                if (str2.equals(ElementViewerJFace.NULL_STRING)) {
                                    return -1;
                                }
                                iRes = str1.compareToIgnoreCase(str2);
                            }
                            return iRes * ElementViewerJFace.this.sortModeArray[0];
                        }
                    });
                }
            }
        });
        idCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ElementViewerJFace.this.toggleCurrentSortMode(1);
                if (ElementViewerJFace.this.sortModeArray[1] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer iviewer, Object e1, Object e2) {
                            int iRes = e1 == null ? -1 : (e2 == null ? 1 : ((VisualizationAttributeInfo)e1).getAttributeValue().compareToIgnoreCase(((VisualizationAttributeInfo)e2).getAttributeValue()));
                            return iRes * ElementViewerJFace.this.sortModeArray[1];
                        }
                    });
                }
            }
        });
        tagCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ElementViewerJFace.this.toggleCurrentSortMode(2);
                if (ElementViewerJFace.this.sortModeArray[2] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer iviewer, Object e1, Object e2) {
                            int iRes = e1 == null ? -1 : (e2 == null ? 1 : ((VisualizationAttributeInfo)e1).getTagName().compareToIgnoreCase(((VisualizationAttributeInfo)e2).getTagName()));
                            return iRes * ElementViewerJFace.this.sortModeArray[2];
                        }
                    });
                }
            }
        });
        this.descCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ElementViewerJFace.this.toggleCurrentSortMode(3);
                if (ElementViewerJFace.this.sortModeArray[3] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer iviewer, Object e1, Object e2) {
                            int iRes;
                            if (e1 == null) {
                                iRes = -1;
                            } else if (e2 == null) {
                                iRes = 1;
                            } else {
                                String str1 = ((VisualizationAttributeInfo)e1).getDescription();
                                String str2 = ((VisualizationAttributeInfo)e2).getDescription();
                                if (str1.equals(ElementViewerJFace.NULL_STRING)) {
                                    return 1;
                                }
                                if (str2.equals(ElementViewerJFace.NULL_STRING)) {
                                    return -1;
                                }
                                iRes = str1.compareToIgnoreCase(str2);
                            }
                            return iRes * ElementViewerJFace.this.sortModeArray[3];
                        }
                    });
                }
            }
        });
    }

    private void viewerSelected(List<VisualizationAttributeInfo> list) {
        this.prb.clearHighlight();
        VisualizationAttributeInfo selected = null;
        Vector<HighlightTargetId> tmpV = new Vector<HighlightTargetId>();
        int i = 0;
        while (i < list.size()) {
            selected = list.get(i);
            tmpV.add(new HighlightTargetId(selected.getNodeId(), selected.getNodeId()));
            if (i == 0) {
                this.strHelpUrl = selected.getHelpUrl();
            } else if (!this.strHelpUrl.equals(selected.getHelpUrl())) {
                this.strHelpUrl = NULL_STRING;
            }
            ++i;
        }
        this.prb.highlight(tmpV);
        IModelService dataSource = ModelServiceUtils.getActiveModelService();
        if (dataSource != null && dataSource instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)dataSource).hightlightElementByAttribute(selected.getAttribtueName(), selected.getAttributeValue());
        }
    }

    private void toggleCurrentSortMode(int sortKind) {
        switch (this.sortModeArray[sortKind]) {
            case -2: {
                this.sortModeArray[sortKind] = 1;
                break;
            }
            case -1: {
                this.sortModeArray[sortKind] = -2;
                break;
            }
            case 0: {
                this.sortModeArray[sortKind] = 1;
                break;
            }
            case 1: {
                this.sortModeArray[sortKind] = -1;
            }
        }
    }

    private void sortByNodeId() {
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer iviewer, Object e1, Object e2) {
                int iRes = e1 == null ? -1 : (e2 == null ? 1 : ((VisualizationAttributeInfo)e1).getNodeId() - ((VisualizationAttributeInfo)e2).getNodeId());
                return iRes;
            }
        });
    }

    private void openPopupMenu() {
        PopupMenu popupMenu;
        String strRet;
        String[] itemName = new String[]{Messages.ElementViewerJFace_0, Messages.ElementViewerJFace_1};
        boolean[] enabled = new boolean[]{true, true};
        if (this.strHelpUrl.equals(NULL_STRING)) {
            enabled[1] = false;
        }
        if ((strRet = (popupMenu = new PopupMenu(new Shell(), itemName, enabled)).open()).equals(itemName[1])) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.strHelpUrl);
        }
    }

    public Composite getComposite() {
        return this.elementViewerComposite;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.viewer.setContentProvider((IContentProvider)contentProvider);
    }

    public void setLabelProvider(ITableLabelProvider labelProvider) {
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setElementList(List<VisualizationAttributeInfo> eleList) {
        this.viewer.setInput(eleList);
    }

    public void setCategoryColWidth(int width) {
        this.categoryCol.setWidth(width);
        if (width == 0) {
            this.categoryCol.setResizable(false);
        }
    }

    public void setDescColWidth(int width) {
        this.descCol.setWidth(width);
        if (width == 0) {
            this.descCol.setResizable(false);
        }
    }
}

