/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowVisionProblemGroup
extends LowVisionProblem {
    int numProblems;
    LowVisionProblem[] problems;
    LowVisionProblem representative = null;
    double sumCharacterScores;
    double groupScore;

    public LowVisionProblemGroup(Vector<LowVisionProblem> _vec) throws LowVisionProblemException {
        this.numProblems = _vec.size();
        if (this.numProblems <= 0) {
            throw new LowVisionProblemException("No instance belong to the group.");
        }
        this.problems = new LowVisionProblem[this.numProblems];
        this.problems[0] = this.representative = _vec.elementAt(0);
        this.pageImage = this.representative.pageImage;
        this.lowVisionType = this.representative.lowVisionType;
        this.problemType = this.representative.problemType;
        this.componentType = this.representative.componentType;
        this.description = this.representative.description;
        this.sumCharacterScores = this.representative.characterScore;
        this.setRecommendations();
        this.isGroupFlag = true;
        int tmpLeft = this.representative.getX();
        int tmpRight = tmpLeft + this.representative.getWidth();
        int tmpTop = this.representative.getY();
        int tmpBottom = tmpTop + this.representative.getHeight();
        int i = 1;
        while (i < this.numProblems) {
            LowVisionProblem curProb = _vec.elementAt(i);
            if (curProb.problemType != this.problemType) {
                throw new LowVisionProblemException("Problems of different types cannot be grouped.");
            }
            this.problems[i] = curProb;
            int curLeft = curProb.getX();
            int curRight = curLeft + curProb.getWidth();
            int curTop = curProb.getY();
            int curBottom = curTop + curProb.getHeight();
            if (curLeft < tmpLeft) {
                tmpLeft = curLeft;
            }
            if (tmpRight < curRight) {
                tmpRight = curRight;
            }
            if (curTop < tmpTop) {
                tmpTop = curTop;
            }
            if (tmpBottom < curBottom) {
                tmpBottom = curBottom;
            }
            this.sumCharacterScores += curProb.characterScore;
            ++i;
        }
        this.left = tmpLeft;
        this.top = tmpTop;
        this.width = tmpRight - tmpLeft;
        this.height = tmpBottom - tmpTop;
        this.groupScore = this.sumCharacterScores / (double)this.width / (double)this.height;
        this.calcProbability();
        this.calcPriority();
    }

    @Override
    protected void setRecommendations() {
        this.numRecommendations = this.representative.numRecommendations;
        this.recommendations = this.representative.recommendations;
    }

    private void calcProbability() throws LowVisionProblemException {
        if (this.numProblems <= 0) {
            throw new LowVisionProblemException("There are no Problems in this ProblemGroup.");
        }
        this.probability = 0.0;
        double maxProba = 0.0;
        int i = 0;
        while (i < this.numProblems) {
            LowVisionProblem curProb = this.problems[i];
            if (maxProba < curProb.probability) {
                maxProba = curProb.probability;
            }
            ++i;
        }
        this.probability = maxProba;
    }

    private void calcPriority() throws LowVisionProblemException {
        if (this.problems[0].pageComponent == null) {
            this.priority = 0;
            return;
        }
        IPageImage pi = this.problems[0].pageComponent.getPageImage();
        if (this.problemType == 3) {
            this.priority = 0;
        } else {
            if (pi == null) {
                throw new LowVisionProblemException("PageImage of the Problem is null.");
            }
            int pageWidth = pi.getWidth();
            int pageHeight = pi.getHeight();
            this.priority = pageWidth * pageHeight - this.top * pageWidth - this.left;
        }
    }

    public LowVisionProblem getRepresentative() {
        return this.representative;
    }

    public int getNumProblems() {
        return this.numProblems;
    }

    public LowVisionProblem[] getProblems() {
        return this.problems;
    }

    public double getSumCharacterScores() {
        return this.sumCharacterScores;
    }

    public double getGroupScore() {
        return this.groupScore;
    }
}

