/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class GlareOp
implements ILowVisionOperator {
    private float glareDegree = 0.0f;

    public GlareOp() {
    }

    public GlareOp(float _deg) throws LowVisionException {
        if (!GlareOp.checkDegree(_deg)) {
            throw new LowVisionException("Glare Degree " + _deg + " is out of range.");
        }
        this.glareDegree = _deg;
    }

    public float getGlareDegree() {
        return this.glareDegree;
    }

    public void setGlareDegree(float _d) {
        this.glareDegree = _d;
    }

    public BufferedImage filter(BufferedImage _src, BufferedImage _dest) throws LowVisionException {
        WritableRaster destRaster;
        DataBufferInt destBufInt;
        int[] destArray;
        int destSize;
        WritableRaster srcRaster = _src.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        int srcSize = srcArray.length;
        BufferedImage destImage = _dest;
        if (_dest == null) {
            destImage = new BufferedImage(_src.getWidth(), _src.getHeight(), 1);
        }
        if (srcSize != (destSize = (destArray = (destBufInt = (DataBufferInt)(destRaster = destImage.copyData(null)).getDataBuffer()).getData()).length)) {
            throw new LowVisionException("Sizes of src and dest images differ.");
        }
        HashMap<Integer, Integer> pixelMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < srcSize) {
            Integer srcPixel = new Integer(srcArray[i]);
            Integer destPixel = null;
            destPixel = (Integer)pixelMap.get(srcPixel);
            if (destPixel == null) {
                destPixel = new Integer(GlareOp.convertColor(srcArray[i], this.glareDegree));
                pixelMap.put(srcPixel, destPixel);
            }
            destArray[i] = destPixel;
            ++i;
        }
        destImage.setData(destRaster);
        return destImage;
    }

    public static int convertColor(int _color, float _degree) throws LowVisionException {
        if (!GlareOp.checkDegree(_degree)) {
            throw new LowVisionException("Glare Degree " + _degree + " is out of range.");
        }
        int[] rgb = ColorUtil.intToRGB(_color);
        int r = GlareOp.convertColorComponent(rgb[0], _degree);
        int g = GlareOp.convertColorComponent(rgb[1], _degree);
        int b = GlareOp.convertColorComponent(rgb[2], _degree);
        return ColorUtil.RGBToInt(r, g, b);
    }

    private static int convertColorComponent(int _component, float _degree) {
        int answer = _component + Math.round(_degree * (float)(255 - _component));
        if (answer < 0) {
            return 0;
        }
        if (answer > 255) {
            return 255;
        }
        return answer;
    }

    private static boolean checkDegree(float _degree) {
        return 0.0f <= _degree && _degree <= 1.0f;
    }
}

