/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class ColorFilterOp
implements ILowVisionOperator {
    private float redRatio = 1.0f;
    private float greenRatio = 0.9f;
    private float blueRatio = 0.6f;

    public float getRedRatio() {
        return this.redRatio;
    }

    public void setRedRatio(float _rf) throws LowVisionException {
        if (_rf < 0.0f || 1.0f < _rf) {
            throw new LowVisionException("Ratio is out of range: " + _rf);
        }
        this.redRatio = _rf;
    }

    public float getGreenRatio() {
        return this.greenRatio;
    }

    public void setGreenRatio(float _gf) throws LowVisionException {
        if (_gf < 0.0f || 1.0f < _gf) {
            throw new LowVisionException("Ratio is out of range: " + _gf);
        }
        this.greenRatio = _gf;
    }

    public float getBlueRatio() {
        return this.blueRatio;
    }

    public void setBlueRatio(float _bf) throws LowVisionException {
        if (_bf < 0.0f || 1.0f < _bf) {
            throw new LowVisionException("Ratio is out of range: " + _bf);
        }
        this.blueRatio = _bf;
    }

    public void setRatio(float[] _rgb) throws LowVisionException {
        if (_rgb.length < 3) {
            throw new LowVisionException("Array is to small.");
        }
        this.setRedRatio(_rgb[0]);
        this.setGreenRatio(_rgb[1]);
        this.setBlueRatio(_rgb[2]);
    }

    public BufferedImage filter(BufferedImage _src, BufferedImage _dest) throws LowVisionException {
        WritableRaster destRaster;
        DataBufferInt destBufInt;
        int[] destArray;
        int destSize;
        WritableRaster srcRaster = _src.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        int srcSize = srcArray.length;
        BufferedImage destImage = _dest;
        if (_dest == null) {
            destImage = new BufferedImage(_src.getWidth(), _src.getHeight(), 1);
        }
        if (srcSize != (destSize = (destArray = (destBufInt = (DataBufferInt)(destRaster = destImage.copyData(null)).getDataBuffer()).getData()).length)) {
            throw new LowVisionException("Sizes of src and dest images differ.");
        }
        HashMap<Integer, Integer> pixelMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < srcSize) {
            Integer srcPixel = new Integer(srcArray[i]);
            Integer destPixel = null;
            destPixel = (Integer)pixelMap.get(srcPixel);
            if (destPixel == null) {
                destPixel = new Integer(ColorFilterOp.convertColor(srcArray[i], this.redRatio, this.greenRatio, this.blueRatio));
                pixelMap.put(srcPixel, destPixel);
            }
            destArray[i] = destPixel;
            ++i;
        }
        destImage.setData(destRaster);
        return destImage;
    }

    public IInt2D filter(Int2D _src, Int2D _dest) throws LowVisionException {
        Int2D destImage = _dest;
        if (_dest == null) {
            destImage = new Int2D(_src.getWidth(), _src.getHeight());
        }
        HashMap<Integer, Integer> pixelMap = new HashMap<Integer, Integer>();
        int j = 0;
        while (j < _src.getHeight()) {
            int i = 0;
            while (i < _src.getWidth()) {
                int srcColor = _src.getData()[j][i];
                Integer srcPixel = new Integer(srcColor);
                Integer destPixel = (Integer)pixelMap.get(srcPixel);
                if (destPixel == null) {
                    int destColor;
                    destImage.getData()[j][i] = destColor = ColorFilterOp.convertColor(srcColor, this.redRatio, this.greenRatio, this.blueRatio);
                    pixelMap.put(srcPixel, new Integer(destColor));
                } else {
                    destImage.getData()[j][i] = destPixel;
                }
                ++i;
            }
            ++j;
        }
        return destImage;
    }

    public static int convertColor(int _src, float _rRatio, float _gRatio, float _bRatio) throws LowVisionException {
        int pixel = _src;
        int b = pixel & 0xFF;
        int newB = Math.round((float)b * _bRatio);
        if (newB < 0 || 255 < newB) {
            throw new LowVisionException("New blue value is out of range: " + newB);
        }
        int g = pixel >> 8 & 0xFF;
        int newG = Math.round((float)g * _gRatio);
        if (newG < 0 || 255 < newG) {
            throw new LowVisionException("New green value is out of range: " + newG);
        }
        int r = pixel >> 16 & 0xFF;
        int newR = Math.round((float)r * _rRatio);
        if (newR < 0 || 255 < newR) {
            throw new LowVisionException("New red value is out of range: " + newR);
        }
        pixel = pixel & 0xFF000000 | newR << 16 | newG << 8 | newB;
        return pixel;
    }
}

