/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;

public class PBMReader {
    public static BinaryImage readBinaryImage(String _fileName) throws LowVisionIOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(_fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + _fileName);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        try {
            char magic1 = (char)br.read();
            char magic2 = (char)br.read();
            if (magic1 != 'P' || magic2 != '1') {
                throw new LowVisionIOException("Bad magic number: " + magic1 + magic2 + "\n\"P4\" cannot be treated in this version.\n(Only \"P1\" is accepted.)");
            }
        }
        catch (IOException iOException) {
            throw new LowVisionIOException("IOException occurred while reading the magic number.");
        }
        StringBuffer sb = new StringBuffer();
        try {
            String oneLine = null;
            while ((oneLine = br.readLine()) != null) {
                int index = oneLine.indexOf("#");
                if (index == -1) {
                    sb.append(String.valueOf(oneLine) + "\n");
                    continue;
                }
                sb.append(String.valueOf(oneLine.substring(0, index)) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading.");
        }
        String content = sb.toString();
        if (!Character.isWhitespace(content.charAt(0))) {
            throw new LowVisionIOException("The magic number must be followed by a white space.");
        }
        content = content.substring(1);
        Pattern pat = Pattern.compile("(\\d+)\\s(\\d+)\\s([01\\s]+)");
        Matcher mat = pat.matcher(content);
        if (!mat.find()) {
            throw new LowVisionIOException("Invalid data format (1).");
        }
        int count = mat.groupCount();
        if (count != 3) {
            throw new LowVisionIOException("Invalid data format (2). count = " + count);
        }
        int width = Integer.parseInt(mat.group(1));
        int height = Integer.parseInt(mat.group(2));
        String dataStr = mat.group(3);
        Pattern pat2 = Pattern.compile("\\s+");
        Matcher mat2 = pat2.matcher(dataStr);
        String data = mat2.replaceAll("");
        if (data.length() != width * height) {
            throw new LowVisionIOException("Data size does not equal to width*height");
        }
        BinaryImage bi = new BinaryImage(width, height);
        byte[][] bidata = bi.getData();
        int k = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                if (data.charAt(k) == '1') {
                    bidata[j][i] = 1;
                }
                ++k;
                ++i;
            }
            ++j;
        }
        return bi;
    }
}

