/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LineSegment;

public class BinaryImage {
    public static final short METHOD_SPECIFY_FOREGROUND = 0;
    public static final short METHOD_SPECIFY_BACKGROUND = 1;
    public static final int NOT_MEASURED = -1;
    int width;
    int height;
    public byte[][] data;
    private int area = -1;

    public BinaryImage(int _w, int _h) {
        this.width = _w;
        this.height = _h;
        this.data = new byte[this.height][this.width];
    }

    public BinaryImage(int _width, int _height, int[][] _data, short _method, int _i) throws ImageException {
        this(new Int2D(_width, _height, _data), _method, _i);
    }

    public BinaryImage(IInt2D _i2d, short _method, int _i) {
        this.width = _i2d.getWidth();
        this.height = _i2d.getHeight();
        this.data = new byte[this.height][this.width];
        if (_method == 0) {
            this.setDataSpecifyForeground(_i2d, _i);
        }
        if (_method == 1) {
            this.setDataSpecifyBackground(_i2d, _i);
        }
    }

    private void setDataSpecifyForeground(IInt2D _i2d, int _foreground) {
        this.area = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (_i2d.getData()[j][i] == _foreground) {
                    this.data[j][i] = 1;
                    ++this.area;
                } else {
                    this.data[j][i] = 0;
                }
                ++i;
            }
            ++j;
        }
    }

    private void setDataSpecifyBackground(IInt2D _i2d, int _background) {
        this.area = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (_i2d.getData()[j][i] == _background) {
                    this.data[j][i] = 0;
                } else {
                    this.data[j][i] = 1;
                    ++this.area;
                }
                ++i;
            }
            ++j;
        }
    }

    public BinaryImage(BufferedImage _bi, short _method, int _i) {
        this.width = _bi.getWidth();
        this.height = _bi.getHeight();
        this.data = new byte[this.height][this.width];
        if (_method == 0) {
            this.setDataSpecifyForeground(_bi, _i);
        }
        if (_method == 1) {
            this.setDataSpecifyBackground(_bi, _i);
        }
    }

    private void setDataSpecifyForeground(BufferedImage _bi, int _foreground) {
        WritableRaster srcRaster = _bi.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        this.area = 0;
        int k = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (srcArray[k] == _foreground) {
                    this.data[j][i] = 1;
                    ++this.area;
                } else {
                    this.data[j][i] = 0;
                }
                ++k;
                ++i;
            }
            ++j;
        }
    }

    private void setDataSpecifyBackground(BufferedImage _bi, int _background) {
        WritableRaster srcRaster = _bi.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        this.area = 0;
        int k = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (srcArray[k] == _background) {
                    this.data[j][i] = 0;
                } else {
                    this.data[j][i] = 1;
                    ++this.area;
                }
                ++k;
                ++i;
            }
            ++j;
        }
    }

    public BinaryImage(int _w, int _h, Coord[] _vertex) {
        this(_w, _h);
        Coord[] vertex = null;
        int numVertex = _vertex.length;
        if (_vertex[0].equals(_vertex[numVertex - 1])) {
            vertex = _vertex;
        } else {
            vertex = new Coord[numVertex + 1];
            int i = 0;
            while (i < numVertex) {
                vertex[i] = _vertex[i];
                ++i;
            }
            vertex[numVertex] = _vertex[0];
            ++numVertex;
        }
        Coord curPoint = new Coord(-1, -1);
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                this.data[j][i] = 1;
                curPoint.set(i, j);
                int k = 0;
                while (k < numVertex - 1) {
                    if (Coord.isLeftToVector(vertex[k], vertex[k + 1], curPoint)) {
                        this.data[j][i] = 0;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        this.measureArea();
    }

    public BinaryImage deepCopy() {
        BinaryImage bi = new BinaryImage(this.width, this.height);
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                bi.data[j][i] = this.data[j][i];
                ++i;
            }
            ++j;
        }
        bi.area = this.area;
        return bi;
    }

    public BinaryImage offsetCopy(int _newWidth, int _newHeight, int _offsetX, int _offsetY, boolean _strict) throws ImageException {
        BinaryImage bi = new BinaryImage(_newWidth, _newHeight);
        if (_offsetX < 0 || _newWidth <= _offsetX) {
            throw new ImageException("Bad offset value.");
        }
        if (_offsetY < 0 || _newHeight <= _offsetY) {
            throw new ImageException("Bad offset value.");
        }
        int endI = this.width;
        int endJ = this.height;
        int overWidth = _offsetX + this.width - _newWidth;
        int overHeight = _offsetY + this.height - _newHeight;
        if (overWidth > 0) {
            if (_strict) {
                throw new ImageException("Not enough image area.");
            }
            endI -= overWidth;
        }
        if (overHeight > 0) {
            if (_strict) {
                throw new ImageException("Not enough image area.");
            }
            endJ -= overHeight;
        }
        int j = 0;
        while (j < endJ) {
            int i = 0;
            while (i < endI) {
                bi.data[j + _offsetY][i + _offsetX] = this.data[j][i];
                ++i;
            }
            ++j;
        }
        return bi;
    }

    public BinaryImage offsetCopy(int _newWidth, int _newHeight, int _offsetX, int _offsetY) throws ImageException {
        return this.offsetCopy(_newWidth, _newHeight, _offsetX, _offsetY, true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[][] getData() {
        return this.data;
    }

    public int getArea() {
        if (this.area == -1) {
            this.measureArea();
        }
        return this.area;
    }

    public int measureArea() {
        this.area = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (this.data[j][i] != 0) {
                    ++this.area;
                }
                ++i;
            }
            ++j;
        }
        return this.area;
    }

    public boolean equals(BinaryImage _bi) {
        if (this.width != _bi.width) {
            return false;
        }
        if (this.height != _bi.height) {
            return false;
        }
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (this.data[j][i] != _bi.data[j][i]) {
                    return false;
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    public BufferedImage toBufferedImage() {
        return this.toBufferedImage(0, 0xFFFFFF);
    }

    public BufferedImage toBufferedImage(int _foreground, int _background) {
        BufferedImage destImage = new BufferedImage(this.width, this.height, 1);
        WritableRaster destRaster = destImage.copyData(null);
        DataBufferInt destBufInt = (DataBufferInt)destRaster.getDataBuffer();
        int[] destArray = destBufInt.getData();
        int k = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                destArray[k] = this.data[j][i] == 0 ? _background : _foreground;
                ++k;
                ++i;
            }
            ++j;
        }
        destImage.setData(destRaster);
        return destImage;
    }

    public LabeledImage labelConnectedComponents() {
        return new LabeledImage(this);
    }

    public LabeledImage labelConnectedComponents(short _method) {
        return new LabeledImage(this, _method);
    }

    public Coord[] extractPoints() {
        Vector<Coord> tmpVec = new Vector<Coord>();
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (this.data[j][i] != 0) {
                    Coord co = new Coord(i, j);
                    tmpVec.addElement(co);
                }
                ++i;
            }
            ++j;
        }
        int size = tmpVec.size();
        if (size > 0) {
            Coord[] coArray = new Coord[size];
            int i = 0;
            while (i < size) {
                coArray[i] = (Coord)tmpVec.elementAt(i);
                ++i;
            }
            return coArray;
        }
        return null;
    }

    public void putPoints(Coord[] _coArray) {
        if (_coArray == null || _coArray.length == 0) {
            return;
        }
        int len = _coArray.length;
        int i = 0;
        while (i < len) {
            Coord co = _coArray[i];
            this.data[co.y][co.x] = 1;
            ++i;
        }
    }

    public Coord topLeftPoint() {
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (this.data[j][i] != 0) {
                    return new Coord(i, j);
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    public static BinaryImage subtract(BinaryImage _bi1, BinaryImage _bi2) throws ImageException {
        int width = _bi1.width;
        int height = _bi1.height;
        if (width != _bi2.width || height != _bi2.height) {
            throw new ImageException("subtract(): Sizes of the two image must be the same");
        }
        BinaryImage newImage = new BinaryImage(width, height);
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                if (_bi1.data[j][i] != 0 && _bi2.data[j][i] == 0) {
                    newImage.data[j][i] = 1;
                }
                ++i;
            }
            ++j;
        }
        return newImage;
    }

    public BinaryImage subtract(BinaryImage _bi) throws ImageException {
        return BinaryImage.subtract(this, _bi);
    }

    public LineSegment detectLongestHorizontalLine() {
        return this.detectLongestHorizontalLine(this.height - 1);
    }

    public LineSegment detectLongestHorizontalLine(int _maxHeight) {
        int maxLength = 0;
        Coord maxStart = new Coord(-1, -1);
        Coord maxEnd = new Coord(-1, -1);
        Coord curStart = new Coord(-1, -1);
        int j = 0;
        while (j <= _maxHeight) {
            boolean flag = false;
            int curLength = 0;
            int i = 0;
            while (i < this.width) {
                if (this.data[j][i] != 0) {
                    if (flag) {
                        ++curLength;
                    } else {
                        flag = true;
                        curLength = 1;
                        curStart.set(i, j);
                    }
                } else if (flag) {
                    if (curLength >= maxLength) {
                        maxLength = curLength;
                        maxStart.copy(curStart);
                        maxEnd.set(i - 1, j);
                    }
                    flag = false;
                }
                ++i;
            }
            if (flag && curLength >= maxLength) {
                maxLength = curLength;
                maxStart.copy(curStart);
                maxEnd.set(this.width - 1, j);
            }
            ++j;
        }
        if (maxLength > 0) {
            return new LineSegment(maxStart, maxEnd);
        }
        return null;
    }

    public BinaryImage drawUnderline() throws ImageException {
        return this.drawLongestHorizontalLine();
    }

    public BinaryImage drawLongestHorizontalLine() throws ImageException {
        LineSegment horSeg = this.detectLongestHorizontalLine();
        if (horSeg == null) {
            return null;
        }
        if (horSeg.isVertical() || horSeg.isDiagonal()) {
            throw new ImageException("Endpoints cannot be successfully detected");
        }
        BinaryImage bi = new BinaryImage(this.width, this.height);
        Coord left = horSeg.getLeftPoint();
        Coord right = horSeg.getRightPoint();
        int i = left.x;
        while (i <= right.x) {
            bi.data[left.y][i] = 1;
            ++i;
        }
        return bi;
    }

    public BinaryImage drawLongestHorizontalLineWithThick() throws ImageException {
        LineSegment horSeg = this.detectLongestHorizontalLine();
        if (horSeg == null) {
            return null;
        }
        if (horSeg.isVertical() || horSeg.isDiagonal()) {
            throw new ImageException("Endpoints cannot be successfully detected");
        }
        BinaryImage bi = new BinaryImage(this.width, this.height);
        Coord left = horSeg.getLeftPoint();
        Coord right = horSeg.getRightPoint();
        int i = left.x;
        while (i <= right.x) {
            bi.data[left.y][i] = 1;
            ++i;
        }
        int maxHeight = left.y - 1;
        int curX0 = left.x;
        int curX1 = right.x;
        while (maxHeight > 0) {
            LineSegment horSeg2 = this.detectLongestHorizontalLine(maxHeight);
            if (horSeg2 == null) break;
            if (horSeg2.isVertical() || horSeg2.isDiagonal()) {
                throw new ImageException("Endpoints cannot be successfully detected");
            }
            Coord left2 = horSeg.getLeftPoint();
            Coord right2 = horSeg.getRightPoint();
            if (left2.y != maxHeight || left2.x != curX0 || right2.x != curX1) break;
            int i2 = left2.x;
            while (i2 <= right2.x) {
                bi.data[maxHeight][i2] = 1;
                ++i2;
            }
            --maxHeight;
        }
        return bi;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw);
    }

    public void dump(PrintWriter _pw) {
        _pw.println("-------------------------------");
        _pw.println("Dumping a BinaryImage");
        _pw.println("Width = " + this.width + ", Height = " + this.height);
        int j = 0;
        while (j < this.height) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.width) {
                if (this.data[j][i] == 0) {
                    sb.append("0");
                } else {
                    sb.append("1");
                }
                ++i;
            }
            _pw.println(sb.toString());
            ++j;
        }
        _pw.println("-------------------------------");
    }

    public void dump(PrintStream _ps, int _left, int _top, int _width, int _height) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw, _left, _top, _width, _height);
    }

    public void dump(PrintWriter _pw, int _left, int _top, int _width, int _height) {
        _pw.println("-------------------------------");
        _pw.println("Dumping a part of a BinaryImage");
        _pw.println("Image width = " + this.width + ", Image height = " + this.height);
        _pw.println("Start point = ( " + _left + ", " + _top + ")");
        _pw.println("Printed width = " + _width + ", Printed height = " + _height);
        int j = 0;
        while (j < _height) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < _width) {
                if (this.data[j + _top][i + _left] == 0) {
                    sb.append("0");
                } else {
                    sb.append("1");
                }
                ++i;
            }
            _pw.println(sb.toString());
            ++j;
        }
        _pw.println("-------------------------------");
    }
}

