/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.character;

import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class CharacterSS
extends PageComponent {
    private int foregroundColor = -1;
    private int backgroundColor = -1;
    private Topology topology = null;

    public CharacterSS(CandidateCharacter _cChar) throws ImageException {
        super((short)4, _cChar.getPageImage());
        this.cc = _cChar.cc;
        this.container = _cChar.getContainer();
        this.foregroundColor = _cChar.getForegroundColor();
        this.backgroundColor = this.container.getColor();
        this.topology = new Topology(this.cc.thinning());
    }

    public CharacterSS(IPageImage _pi, ConnectedComponent _cc, Container _cont, int _fg) throws ImageException {
        super((short)4, _pi);
        this.cc = _cc;
        this.container = _cont;
        this.foregroundColor = _fg;
        this.backgroundColor = this.container.getColor();
        this.topology = new Topology(this.cc.thinning());
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public IInt2D makeMarginedImage(int _margin) {
        Int2D i2d = new Int2D(this.cc.getShape().getWidth() + 2 * _margin, this.cc.getShape().getHeight() + 2 * _margin);
        i2d.fill(this.backgroundColor);
        byte[][] data = this.cc.getShape().getData();
        int j = 0;
        while (j < this.cc.getShape().getHeight()) {
            int i = 0;
            while (i < this.cc.getShape().getWidth()) {
                if (data[j][i] != 0) {
                    i2d.getData()[j + _margin][i + _margin] = this.foregroundColor;
                }
                ++i;
            }
            ++j;
        }
        return i2d;
    }

    public Topology getTopology() {
        return this.topology;
    }
}

