/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProblemItemLV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowVisionProblemConverter {
    public static List<IProblemItem> convert(LowVisionProblemGroup[] target, String urlS, int frameId) {
        ArrayList<IProblemItem> result = new ArrayList<IProblemItem>();
        int i = 0;
        while (i < target.length) {
            ProblemItemLV tmp;
            ColorProblem cp;
            int type = target[i].getLowVisionProblemType();
            if (type == 1) {
                cp = (ColorProblem)target[i].getRepresentative();
                tmp = new ProblemItemLV("L_" + target[i].getLowVisionProblemType() + "." + cp.getLevel());
                tmp.setTargetNode(cp.getElement());
                tmp.setTargetString(cp.getAdditionalDescription());
            } else {
                tmp = new ProblemItemLV("L_" + target[i].getLowVisionProblemType());
            }
            tmp.setSubType(type);
            try {
                switch (type) {
                    case 10: {
                        cp = (ColorProblem)target[i].getRepresentative();
                        tmp.setTargetNode(cp.getElement());
                        tmp.setTargetString(cp.getAdditionalDescription());
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        tmp.setDescription(target[i].getDescription());
                        if (target[i].getRepresentative() != null) {
                            tmp.setTargetNode(target[i].getRepresentative().getElement());
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                tmp.setDescription("unknown");
            }
            tmp.setCanHighlight(true);
            tmp.setFrameId(frameId);
            tmp.setFrameUrl(urlS);
            tmp.setSeverityLV(target[i].getIntProbability());
            tmp.setForeground(LowVisionProblemConverter.getLVProblemColorString(target[i], true));
            tmp.setBackground(LowVisionProblemConverter.getLVProblemColorString(target[i], false));
            tmp.setX(target[i].getX());
            tmp.setY(target[i].getY());
            tmp.setWidth(target[i].getWidth());
            tmp.setHeight(target[i].getHeight());
            tmp.setArea(target[i].getWidth() * target[i].getHeight());
            result.add((IProblemItem)tmp);
            ++i;
        }
        return result;
    }

    private static String getLVProblemColorString(LowVisionProblemGroup problem, boolean isFore) {
        int probType = problem.getLowVisionProblemType();
        if (probType == 1 || probType == 10) {
            ColorProblem cp = (ColorProblem)problem.getRepresentative();
            int origAll = isFore ? cp.getForegroundColor() : cp.getBackgroundColor();
            int origR = origAll >> 16 & 0xFF;
            int origG = origAll >> 8 & 0xFF;
            int origB = origAll & 0xFF;
            return String.valueOf(origR) + "," + origG + "," + origB;
        }
        return " ";
    }
}

