/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAPropertiesView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeEntry;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class MSAAPropertiesView
extends ViewPart
implements IMSAAPropertiesView {
    private PropertyTreeViewer viewer;
    private Action refreshAction;
    private Action showNullAction;
    private Action changeColorAction;
    private Action copyAction;
    private Action invokeAction;
    private PropertiesFilter filter;
    public static final String SEPARATOR = "-";
    private static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();

    public void createPartControl(Composite parent) {
        this.viewer = new PropertyTreeViewer(parent, 98308);
        this.viewer.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.filter = new PropertiesFilter();
        this.viewer.addFilter(this.filter);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        if (MSAAViewRegistory.outlineObject != null) {
            this.setInput(MSAAViewRegistory.outlineObject);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSAAPropertiesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showNullAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.changeColorAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        Object selected = this.getSelectedItem();
        if (selected instanceof PropertyTreeEntry && ((PropertyTreeEntry)selected).canInvoke()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.invokeAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private Object getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.msaa_refresh){

            public void run() {
                MSAAPropertiesView.this.viewer.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.msaa_refresh);
        this.refreshAction.setImageDescriptor(GuiImages.IMAGE_REFRESH);
        this.showNullAction = new Action(Messages.msaa_showNull, 2){

            public void run() {
                ((MSAAPropertiesView)MSAAPropertiesView.this).filter.showNull = MSAAPropertiesView.this.showNullAction.isChecked();
                MSAAPropertiesView.this.viewer.refresh();
            }
        };
        this.showNullAction.setChecked(this.filter.showNull);
        this.changeColorAction = new Action(Messages.msaa_changePropertiesColor, 2){

            public void run() {
                ((MSAAPropertiesView)MSAAPropertiesView.this).filter.changeColor = MSAAPropertiesView.this.changeColorAction.isChecked();
                MSAAPropertiesView.this.viewer.refresh();
            }
        };
        this.changeColorAction.setChecked(this.filter.changeColor);
        this.copyAction = new Action(Messages.msaa_copy){

            public void run() {
                ISelection selection = MSAAPropertiesView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    String strText = null;
                    String strValue = null;
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof PropertyTreeEntry) {
                        strText = ((PropertyTreeEntry)element).getDisplayName();
                        strValue = ((PropertyTreeEntry)element).getValueAsString();
                    } else if (element instanceof IPropertySheetEntry) {
                        strText = ((IPropertySheetEntry)element).getDisplayName();
                        strValue = ((IPropertySheetEntry)element).getValueAsString();
                    }
                    if (strText != null) {
                        if (strValue != null) {
                            strText = String.valueOf(strText) + "\t" + strValue;
                        }
                        new Clipboard(Display.getCurrent()).setContents(new Object[]{strText}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
            }
        };
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.invokeAction = new Action(Messages.msaa_invoke){

            public void run() {
                MSAAPropertiesView.this.viewer.invoke(MSAAPropertiesView.this.getSelectedItem());
            }
        };
    }

    private class PropertiesFilter
    extends ViewerFilter {
        public boolean showNull = false;
        public boolean changeColor = false;
        public String separateColor = Integer.toString(15);
        public String hilightColor = Integer.toString(9);

        private PropertiesFilter() {
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            ArrayList<Object> outList = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof PropertyTreeEntry) {
                    PropertyTreeEntry entry = (PropertyTreeEntry)elements[i];
                    String value = entry.getValueAsString();
                    if (this.showNull || !"null".equals(value)) {
                        String lastValue;
                        Map<String, String> lastContents;
                        if (this.changeColor && viewer instanceof PropertyTreeViewer && !(lastContents = ((PropertyTreeViewer)viewer).getLastContents()).isEmpty() && (lastValue = lastContents.get(entry.getPath())) != null) {
                            if (value == null) {
                                value = "";
                            }
                            entry.setColor(value.equals(lastValue) ? -1 : 9);
                        }
                        outList.add(entry);
                    }
                } else {
                    outList.add(elements[i]);
                }
                ++i;
            }
            return outList.toArray();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return false;
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof PropertyTreeEntry) {
                PropertyTreeEntry entry = (PropertyTreeEntry)obj;
                if (index == 0) {
                    String text = entry.getDisplayName();
                    if (entry.canInvoke()) {
                        text = String.valueOf(text) + "...";
                    }
                    return text;
                }
                return entry.getValueAsString();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Color getForeground(Object element) {
            int color;
            if (element instanceof PropertyTreeEntry && -1 != (color = ((PropertyTreeEntry)element).getColor())) {
                return Display.getCurrent().getSystemColor(color);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

