/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2text;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractInputField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.TextOffsetField;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.MethodData;

public class IA2TextTextMethod
extends MethodData {
    private AccessibleText accessibleText;
    private TextOffsetField startOffsetField;
    private TextOffsetField endOffsetField;

    public IA2TextTextMethod(AccessibleText accessibleText) {
        super("text", true);
        this.accessibleText = accessibleText;
        int max = accessibleText.getCharacterCount();
        this.startOffsetField = new TextOffsetField("startOffset", 0, accessibleText);
        this.endOffsetField = new TextOffsetField("endOffset", max, accessibleText);
        this.setInputFields(new AbstractInputField[]{this.startOffsetField, this.endOffsetField});
    }

    public Object getResult() {
        int startOffset = this.startOffsetField.getIntValue();
        int endOffset = this.endOffsetField.getIntValue();
        String text = this.accessibleText.getTextRange(startOffset, endOffset);
        return this.formatResult("text=" + IA2TextTextMethod.T(text));
    }
}

