/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleRelation;
import org.eclipse.actf.visualization.gui.msaa.properties.AccessibleObjectPropertySource;
import org.eclipse.actf.visualization.gui.msaa.properties.AccessibleRelationPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ObjectArrayPropertySource
implements IPropertySource {
    private Object[] objArray;
    private String editableText;

    public ObjectArrayPropertySource(Object[] strArray) {
        this.objArray = strArray;
    }

    public ObjectArrayPropertySource(Object[] strArray, String editableText) {
        this(strArray);
        this.editableText = editableText;
    }

    public ObjectArrayPropertySource(int[] intArray) {
        this.objArray = new Object[intArray.length];
        int i = 0;
        while (i < intArray.length) {
            this.objArray[i] = new Integer(intArray[i]);
            ++i;
        }
    }

    public ObjectArrayPropertySource(int[] intArray, String editableText) {
        this(intArray);
        this.editableText = editableText;
    }

    public Object getEditableValue() {
        if (this.editableText != null) {
            return this.editableText;
        }
        return ObjectArrayPropertySource.objectArrayToString(this.objArray);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[this.objArray.length];
        int i = 0;
        while (i < this.objArray.length) {
            descriptors[i] = new PropertyDescriptor((Object)new Integer(i), "[" + i + "]");
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof Integer) {
            Object obj = this.objArray[(Integer)id];
            if (obj instanceof AccessibleObject) {
                return new AccessibleObjectPropertySource((AccessibleObject)obj);
            }
            if (obj instanceof AccessibleRelation) {
                return new AccessibleRelationPropertySource((AccessibleRelation)obj);
            }
            return obj.toString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static String objectArrayToString(Object[] objArray) {
        String strRet = null;
        if (objArray != null) {
            int i = 0;
            while (i < objArray.length) {
                strRet = i == 0 ? "" : String.valueOf(strRet) + "; ";
                strRet = String.valueOf(strRet) + objArray[i];
                ++i;
            }
        }
        return strRet;
    }
}

