/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AttributePropertySource
implements IPropertySource {
    private Map<Object, Object> attrMap = new LinkedHashMap<Object, Object>();
    private String attributes;
    private String editableText;

    public AttributePropertySource(String attributes) {
        this.attributes = attributes;
        if (attributes != null) {
            StringTokenizer st = new StringTokenizer(attributes, ";");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                String value = null;
                int sep = name.indexOf(58);
                if (sep > 0) {
                    value = name.substring(sep + 1).trim();
                    name = name.substring(0, sep).trim();
                }
                this.put(name, value);
            }
        }
    }

    public AttributePropertySource(String attributes, String editableText) {
        this(attributes);
        this.editableText = editableText;
    }

    public void put(Object key, Object value) {
        this.attrMap.put(key, value);
    }

    public Object getEditableValue() {
        if (this.editableText != null) {
            return this.editableText;
        }
        return this.attributes;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (Object name : this.attrMap.keySet()) {
            descriptors.add(new PropertyDescriptor(name, (String)name));
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        return this.attrMap.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

