/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.IA2Util;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.TextMap;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ScreenReaderRenderer {
    private static final String SPACE = " ";
    private int lastHwnd = 0;
    private String lastText = "";
    private StyledText text;
    private TextMap textMap;
    private static final MSAATreeContentProvider provider = MSAATreeContentProvider.getDefault();
    private static final Display display = Display.getCurrent();
    private static RenderThread renderThread = null;
    private static DisposeListener disposeListener = null;
    private static final int IDLE_WAIT = 5;
    private static final int BUSY_WAIT = 500;
    public static int waitMS = 5;
    private IFlashDOMView flashDOMView = (IFlashDOMView)MSAAViewRegistory.findView("org.eclipse.actf.visualization.flash.ui.views.FlashDOMView");
    private static final String[] BROWSER_CONTENT_CLASSNAMES = new String[]{"Internet Explorer_Server", "MozillaWindowClass", "MozillaContentWindowClass"};

    private static boolean isBrowserContent(String className) {
        int i = 0;
        while (i < BROWSER_CONTENT_CLASSNAMES.length) {
            if (BROWSER_CONTENT_CLASSNAMES[i].equals(className)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ScreenReaderRenderer(StyledText text, TextMap textMap) {
        this.text = text;
        this.textMap = textMap;
        if (disposeListener == null) {
            disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (renderThread != null) {
                        renderThread.cancel = true;
                        renderThread.interrupt();
                        ScreenReaderRenderer.renderThread = null;
                        ScreenReaderRenderer.disposeListener = null;
                    }
                }
            };
            text.addDisposeListener(disposeListener);
        }
    }

    public void renderAll(AccessibleObject object) {
        AccessibleObject parent;
        if (renderThread != null) {
            ScreenReaderRenderer.renderThread.cancel = true;
            renderThread.interrupt();
        }
        this.text.setText("");
        if (this.textMap != null) {
            this.textMap.clear();
        }
        if ((parent = object.getCachedParent()) != null) {
            renderThread = new RenderThread(provider.getElements(parent));
            renderThread.start();
            Thread.yield();
        }
    }

    public static void setBusy(boolean busy) {
        waitMS = busy ? 500 : 5;
    }

    public String renderItem(AccessibleObject accObject, boolean selected, int parentIndex) {
        boolean visible;
        String accName = accObject.getAccName();
        String outText = accName == null ? "" : accName.replace('\u00a0', ' ').trim();
        int accState = accObject.getAccState();
        int accRole = accObject.getAccRole();
        boolean isFlash = FlashMSAAUtil.isFlash((int)accObject.getPtr());
        boolean isBrowser = ScreenReaderRenderer.isBrowserContent(accObject.getClassName());
        String prefix = "";
        String postfix = "";
        String defaultAction = accObject.getAccDefaultAction();
        boolean clickable = defaultAction != null && defaultAction.length() > 0;
        boolean bl = visible = (accObject.getAccState() & 0x8000) == 0;
        int foreground = visible ? (clickable ? 9 : -1) : 15;
        int background = selected ? 13 : -1;
        block1 : switch (accRole) {
            case 42: {
                boolean editable;
                boolean bl2 = editable = (accState & 0x40) == 0;
                if (!isBrowser || editable) {
                    prefix = editable ? Messages.msaa_edit : Messages.msaa_edit_readonly;
                    outText = accObject.getAccValue();
                    if (outText != null && outText.length() != 0) break;
                    outText = SPACE;
                    break;
                }
            }
            case 41: {
                if (!outText.equals(this.lastText)) break;
                outText = "";
                break;
            }
            case 40: {
                if (isFlash) {
                    prefix = Messages.msaa_graphic;
                } else {
                    postfix = Messages.msaa_graphic;
                }
                if (!outText.equals(this.lastText)) break;
                outText = "";
                break;
            }
            case 30: {
                prefix = Messages.msaa_link;
                break;
            }
            case 44: {
                prefix = String.valueOf(Messages.msaa_checkbox) + SPACE;
                prefix = String.valueOf(prefix) + ((accState & 0x10) != 0 ? Messages.msaa_checked : Messages.msaa_not_checked);
                break;
            }
            case 45: {
                prefix = String.valueOf(Messages.msaa_radiobutton) + SPACE;
                prefix = String.valueOf(prefix) + ((accState & 0x10) != 0 ? Messages.msaa_checked : Messages.msaa_not_checked);
                break;
            }
            case 51: {
                outText = accObject.getAccValue();
                postfix = Messages.msaa_updown_scrollbat;
                break;
            }
            case 48: {
                outText = accObject.getAccValue();
                postfix = Messages.msaa_progressbar;
                break;
            }
            case 52: {
                outText = accObject.getAccValue();
                postfix = Messages.msaa_editspinbox;
                break;
            }
            case 46: {
                prefix = Messages.msaa_combobox;
                outText = accObject.getAccValue();
                if (outText != null && outText.length() != 0) break;
                outText = accObject.getAccName();
                break;
            }
            case 43: 
            case 56: 
            case 62: {
                postfix = Messages.msaa_button;
                if (outText.length() != 0) break;
                if (isFlash) {
                    outText = Integer.toString(parentIndex);
                    foreground = 3;
                    break;
                }
                outText = SPACE;
                break;
            }
            case 34: {
                AccessibleObject parent = accObject.getCachedParent();
                if (parent == null) break;
                switch (parent.getAccRole()) {
                    case 33: {
                        postfix = Messages.msaa_listbox;
                        if ((accState & 2) == 0) break block1;
                        postfix = String.valueOf(postfix) + SPACE + Messages.msaa_selected;
                        break;
                    }
                    case 46: {
                        prefix = Messages.msaa_combobox;
                    }
                }
                break;
            }
            case 24: {
                postfix = Messages.msaa_table;
                break;
            }
            case 29: {
                postfix = Messages.msaa_cell;
                break;
            }
            case 25: {
                postfix = Messages.msaa_columnheader;
                break;
            }
            case 26: {
                postfix = Messages.msaa_rowheader;
                break;
            }
            case 37: {
                postfix = Messages.msaa_tab;
                break;
            }
            case 36: {
                postfix = Messages.msaa_treeview;
                if ((accState & 2) != 0) {
                    postfix = String.valueOf(postfix) + SPACE + Messages.msaa_selected;
                    break;
                }
                if (!isFlash) break;
                outText = "";
                break;
            }
            case 35: {
                postfix = Messages.msaa_tree;
                break;
            }
            case 2: {
                postfix = Messages.msaa_menubar;
                break;
            }
            case 11: 
            case 12: {
                if ((accState & 1) != 0) {
                    postfix = Messages.msaa_unavailable;
                    break;
                }
                if (accObject.getChildCount() > 0) {
                    AccessibleObject parent = accObject.getCachedParent();
                    if (parent != null && 12 == parent.getAccRole()) {
                        postfix = Messages.msaa_submenu;
                        break;
                    }
                    postfix = Messages.msaa_menu;
                    break;
                }
                if ((accState & 0x10) == 0) break;
                postfix = Messages.msaa_checked;
                break;
            }
            case 22: {
                postfix = Messages.msaa_toolbar;
                break;
            }
            case 23: {
                postfix = Messages.msaa_statusbar;
                break;
            }
            case 3: {
                postfix = Messages.msaa_scrollbar;
                break;
            }
            case 39: {
                postfix = Messages.msaa_indicator;
                break;
            }
            case 14: {
                postfix = Messages.msaa_application;
                break;
            }
            case 15: {
                postfix = Messages.msaa_document;
                break;
            }
            case 9: 
            case 16: {
                if (isFlash) {
                    outText = "";
                    break;
                }
                postfix = Messages.msaa_window;
                break;
            }
            case 10: {
                if (!isFlash && !isBrowser && !outText.equals(this.lastText)) break;
                outText = "";
                break;
            }
            case 1052: 
            case 1057: {
                break;
            }
            case 1061: {
                String style = null;
                Accessible2 ac2 = accObject.getAccessible2();
                if (ac2 != null) {
                    style = IA2Util.getAttribute(ac2.getAttributes(), "style");
                }
                if (style != null) {
                    postfix = MessageFormat.format((String)Messages.ia2_style_shape, (Object[])new Object[]{style});
                    break;
                }
                postfix = String.valueOf(postfix) + Messages.ia2_shape;
                break;
            }
            case 1027: 
            case 1055: {
                String[] extendedStates;
                if ((accState & 1) != 0) {
                    postfix = Messages.msaa_unavailable;
                    break;
                }
                Accessible2 ac2 = accObject.getAccessible2();
                if (ac2 == null || !IA2Util.getExtendedState(extendedStates = ac2.getExtendedStates(8), "CHECKED")) break;
                postfix = Messages.msaa_checked;
                break;
            }
            case 1044: {
                Accessible2 ac2;
                String level = "?";
                try {
                    ac2 = accObject.getAccessible2();
                    if (ac2 != null) {
                        level = IA2Util.getAttribute(ac2.getAttributes(), "heading-level");
                    }
                }
                catch (Exception exception) {}
                prefix = MessageFormat.format((String)Messages.ia2_heading_level, (Object[])new Object[]{level});
            }
            case 1054: {
                outText = accObject.getAccValue();
                if (outText != null && outText.length() != 0) break;
                outText = accObject.getAccName();
                break;
            }
            default: {
                prefix = "[" + accObject.getRoleText() + " 0x" + Integer.toHexString(accRole) + "]";
            }
        }
        String speakText = "";
        Point point = new Point(this.text.getCharCount(), 0);
        if (outText != null && outText.length() > 0) {
            if (SPACE.equals(outText)) {
                outText = "";
            }
            if (prefix.length() > 0) {
                if (outText.length() > 0) {
                    prefix = String.valueOf(prefix) + SPACE;
                }
                this.appendText(prefix, 15, background, false);
                speakText = String.valueOf(speakText) + prefix;
            }
            if (outText.length() > 0) {
                this.appendText(outText, foreground, background, clickable);
                speakText = String.valueOf(speakText) + outText;
            }
            if (postfix.length() > 0) {
                if (speakText.length() > 0) {
                    postfix = SPACE + postfix;
                }
                this.appendText(postfix, 15, background, false);
                speakText = String.valueOf(speakText) + postfix;
            }
            this.text.append("\n");
            this.lastText = outText;
        }
        point.y = this.text.getCharCount();
        if (this.textMap != null) {
            this.textMap.put(accObject, point);
        }
        return speakText;
    }

    public String renderEvent(int event) {
        String eventText = "";
        switch (event) {
            case 4: {
                eventText = Messages.msaa_menu_start;
                break;
            }
            case 6: {
                eventText = Messages.msaa_popup_start;
                break;
            }
            case 5: {
                eventText = Messages.msaa_menu_end;
                break;
            }
            case 7: {
                eventText = Messages.msaa_popup_end;
            }
        }
        if (eventText.length() > 0) {
            this.appendText(eventText, 15, -1, false);
            this.text.append("\n");
            this.lastText = eventText;
        }
        return eventText;
    }

    private void appendText(String str, int foreground, int background, boolean underline) {
        StyleRange range = new StyleRange();
        if (foreground >= 0) {
            range.foreground = Display.getCurrent().getSystemColor(foreground);
        }
        if (background >= 0) {
            range.background = Display.getCurrent().getSystemColor(background);
        }
        range.underline = underline;
        range.start = this.text.getCharCount();
        range.length = str.length();
        this.text.append(str);
        this.text.setStyleRange(range);
    }

    private class RenderThread
    extends Thread {
        private Object[] startElements;
        public boolean cancel = false;

        public RenderThread(Object[] startElements) {
            this.startElements = startElements;
        }

        public void run() {
            try {
                this.renderElements(this.startElements);
                display.syncExec(new Runnable(){

                    public void run() {
                        if (!RenderThread.this.cancel && !ScreenReaderRenderer.this.text.isDisposed() && ScreenReaderRenderer.this.text.getCharCount() <= 0) {
                            ScreenReaderRenderer.this.appendText(provider.isHideHtml() ? Messages.msaa_no_flash : Messages.msaa_empty_page, 15, -1, false);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {}
        }

        private void renderElements(Object[] inputElements) throws InterruptedException {
            if (inputElements == null) {
                return;
            }
            int i = 0;
            while (i < inputElements.length) {
                if (this.cancel) {
                    throw new InterruptedException();
                }
                if (inputElements[i] instanceof AccessibleObject) {
                    final int index = i;
                    final boolean[] sayFlashEnd = new boolean[1];
                    final Object[][] renderChildren = new Object[1][];
                    final AccessibleObject accObject = (AccessibleObject)inputElements[i];
                    display.syncExec(new Runnable(){

                        public void run() {
                            if (!RenderThread.this.cancel && !ScreenReaderRenderer.this.text.isDisposed()) {
                                int hwnd = accObject.getWindow();
                                if (hwnd != ScreenReaderRenderer.this.lastHwnd) {
                                    if (FlashMSAAUtil.isFlash((int)accObject.getPtr())) {
                                        String wmode = null;
                                        if (hwnd == 0) {
                                            wmode = FlashMSAAUtil.getHtmlAttribute((int)accObject.getPtr(), (String)"WMode");
                                        }
                                        if (wmode == null) {
                                            AccessibleObject parentObject = accObject.getCachedParent();
                                            if (parentObject != null && hwnd != parentObject.getWindow()) {
                                                ScreenReaderRenderer.this.appendText(String.valueOf(Messages.msaa_flash_start) + "\n", 15, 13, false);
                                                sayFlashEnd[0] = true;
                                            }
                                        } else {
                                            ScreenReaderRenderer.this.appendText(String.valueOf(Messages.msaa_flash_inaccessible) + " wmode=" + wmode + "\n", 15, 3, false);
                                            if (ScreenReaderRenderer.this.flashDOMView != null) {
                                                ScreenReaderRenderer.this.flashDOMView.addWindowlessElement(accObject);
                                            }
                                        }
                                    }
                                    ScreenReaderRenderer.this.lastHwnd = hwnd;
                                }
                                ScreenReaderRenderer.this.renderItem(accObject, false, index);
                                renderChildren[0] = provider.getChildren(accObject);
                            }
                        }
                    });
                    this.renderElements(renderChildren[0]);
                    if (sayFlashEnd[0]) {
                        display.syncExec(new Runnable(){

                            public void run() {
                                if (!RenderThread.this.cancel && !ScreenReaderRenderer.this.text.isDisposed()) {
                                    ScreenReaderRenderer.this.appendText(String.valueOf(Messages.msaa_flash_end) + "\n", 15, 13, false);
                                }
                            }
                        });
                    }
                    Thread.yield();
                    Thread.sleep(waitMS);
                    ScreenReaderRenderer.setBusy(false);
                }
                ++i;
            }
        }
    }
}

