/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleTable;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleTableModelChange;
import org.eclipse.actf.accservice.swtbridge.ia2.RowColumnExtents;
import org.eclipse.actf.accservice.swtbridge.internal.InternalAccessibleObject;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleTable;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.internal.ole.win32.COM;

public class InternalAccessibleTable
implements AccessibleTable {
    private IAccessibleTable accessibleTable = null;

    public InternalAccessibleTable(int address) {
        this.accessibleTable = new IAccessibleTable(address);
        this.accessibleTable.AddRef();
    }

    public void dispose() {
        if (this.accessibleTable != null) {
            this.accessibleTable.Release();
            this.accessibleTable = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public AccessibleObject getAccessibleCellAt(int row, int column) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_accessibleAt(row, column, nia.getAddress()) == 0) {
                    AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nia.getInt());
                    return accessibleObject;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public Object getAccessibleCaption() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_caption(nia.getAddress()) == 0) {
                    AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nia.getInt());
                    return accessibleObject;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getAccessibleIndex(int rowIndex, int columnIndex) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_childIndex(rowIndex, columnIndex, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public String getAccessibleColumnDescription(int column) {
        if (this.accessibleTable != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleTable.get_columnDescription(column, nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public int getAccessibleColumnExtentAt(int row, int column) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_columnExtentAt(row, column, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public InternalAccessibleTable getAccessibleColumnHeaders(int[] startingRowIndex) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            try {
                if (this.accessibleTable.get_columnHeader(nia.getAddress(0), nia.getAddress(1)) == 0) {
                    startingRowIndex[0] = nia.getInt(1);
                    InternalAccessibleTable internalAccessibleTable = new InternalAccessibleTable(nia.getInt(0));
                    return internalAccessibleTable;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getAccessibleColumnIndex(int childIndex) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_columnIndex(childIndex, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public int getAccessibleColumnCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nColumns(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getAccessibleRowCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nRows(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getSelectedAccessibleChildCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nSelectedChildren(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getSelectedAccessibleColumnCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nSelectedColumns(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getSelectedAccessibleRowCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nSelectedRows(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public String getAccessibleRowDescription(int row) {
        if (this.accessibleTable != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleTable.get_rowDescription(row, nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public int getAccessibleRowExtentAt(int row, int column) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_rowExtentAt(row, column, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public InternalAccessibleTable getAccessibleRowHeaders(int[] startingColumnIndex) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            try {
                if (this.accessibleTable.get_rowHeader(nia.getAddress(0), nia.getAddress(1)) == 0) {
                    startingColumnIndex[0] = nia.getInt(1);
                    InternalAccessibleTable internalAccessibleTable = new InternalAccessibleTable(nia.getInt(0));
                    return internalAccessibleTable;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getAccessibleRowIndex(int childIndex) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_rowIndex(childIndex, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int[] getSelectedAccessibleChildren(int maxChildren) {
        if (this.accessibleTable != null && maxChildren > 0) {
            NativeIntAccess nia = new NativeIntAccess(maxChildren + 1);
            try {
                if (this.accessibleTable.get_selectedChildren(maxChildren, nia.getAddress(1), nia.getAddress(0)) == 0) {
                    int count = nia.getInt(0);
                    int[] pRet = new int[count];
                    MemoryUtil.MoveMemory((int[])pRet, (int)nia.getInt(1), (int)(4 * count));
                    COM.CoTaskMemFree((int)nia.getInt(1));
                    int[] nArray = pRet;
                    return nArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int[] getSelectedAccessibleRows(int maxRows) {
        if (this.accessibleTable != null && maxRows > 0) {
            NativeIntAccess nia = new NativeIntAccess(maxRows + 1);
            try {
                if (this.accessibleTable.get_selectedRows(maxRows, nia.getAddress(1), nia.getAddress(0)) == 0) {
                    int count = nia.getInt(0);
                    int[] pRet = new int[count];
                    MemoryUtil.MoveMemory((int[])pRet, (int)nia.getInt(1), (int)(4 * count));
                    COM.CoTaskMemFree((int)nia.getInt(1));
                    int[] nArray = pRet;
                    return nArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int[] getSelectedAccessibleColumns(int maxColumns) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess(maxColumns + 1);
            try {
                if (this.accessibleTable.get_selectedColumns(maxColumns, nia.getAddress(1), nia.getAddress(0)) == 0) {
                    int count = nia.getInt(0);
                    int[] pRet = new int[count];
                    MemoryUtil.MoveMemory((int[])pRet, (int)nia.getInt(1), (int)(4 * count));
                    COM.CoTaskMemFree((int)nia.getInt(1));
                    int[] nArray = pRet;
                    return nArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public Object getAccessibleSummary() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_summary(nia.getAddress()) == 0) {
                    AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nia.getInt());
                    return accessibleObject;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public boolean isAccessibleColumnSelected(int column) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_isColumnSelected(column, nia.getAddress()) == 0) {
                    boolean bl = nia.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return false;
    }

    public boolean isAccessibleRowSelected(int row) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_isRowSelected(row, nia.getAddress()) == 0) {
                    boolean bl = nia.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return false;
    }

    public boolean isAccessibleSelected(int row, int column) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_isSelected(row, column, nia.getAddress()) == 0) {
                    boolean bl = nia.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return false;
    }

    public boolean selectAccessibleRow(int row) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.selectRow(row) == 0;
        }
        return false;
    }

    public boolean selectAccessibleColumn(int column) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.selectColumn(column) == 0;
        }
        return false;
    }

    public boolean unselectAccessibleRow(int row) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.unselectRow(row) == 0;
        }
        return false;
    }

    public boolean unselectAccessibleColumn(int column) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.unselectColumn(column) == 0;
        }
        return false;
    }

    public RowColumnExtents getAccessibleRowColumnExtentAtIndex(int index) {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess(5);
            try {
                if (this.accessibleTable.get_rowColumnExtentsAtIndex(index, nia.getAddress(0), nia.getAddress(1), nia.getAddress(2), nia.getAddress(3), nia.getAddress(4)) == 0) {
                    RowColumnExtents rowColumnExtents = new RowColumnExtents(nia.getAddress(0), nia.getAddress(1), nia.getAddress(2), nia.getAddress(3), nia.getAddress(4) != 0);
                    return rowColumnExtents;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public AccessibleTableModelChange getAccessibleTableModelChange() {
        if (this.accessibleTable != null) {
            NativeIntAccess nia = new NativeIntAccess(5);
            try {
                if (this.accessibleTable.get_modelChange(nia.getAddress()) == 0) {
                    AccessibleTableModelChange accessibleTableModelChange = new AccessibleTableModelChange(nia.getAddress(0), nia.getAddress(1), nia.getAddress(2), nia.getAddress(3), nia.getAddress(4));
                    return accessibleTableModelChange;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }
}

