/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.accservice.swtbridge.AccessibleFactoryEntry;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.IAccessibleObjectFactory;
import org.eclipse.actf.accservice.swtbridge.event.IAccessibleEventMonitor;
import org.eclipse.actf.accservice.swtbridge.internal.InternalAccessibleObject;
import org.eclipse.actf.accservice.swtbridge.internal.InternalAccessibleObjectFactory;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.ole.win32.Variant;

public class AccessibleObjectFactory {
    public static String currentFactoryId;
    private static IAccessibleObjectFactory currentFactory;
    private static Map<String, AccessibleFactoryEntry> factoryEntries;

    static {
        factoryEntries = new HashMap<String, AccessibleFactoryEntry>();
        AccessibleObjectFactory.addFactoryEntry(InternalAccessibleObjectFactory.ID, new AccessibleFactoryEntry(Messages.AccessibleObjectFactory_0, new InternalAccessibleObjectFactory()));
        AccessibleObjectFactory.setActiveFactory(InternalAccessibleObjectFactory.ID);
    }

    public static AccessibleObject getAccessibleObjectFromPoint(Point point) {
        if (currentFactory != null) {
            return currentFactory.getAccessibleObjectFromPoint(point);
        }
        return null;
    }

    public static AccessibleObject getAccessibleObjectFromWindow(int hwnd) {
        if (currentFactory != null) {
            return currentFactory.getAccessibleObjectFromWindow(hwnd);
        }
        return null;
    }

    public static AccessibleObject getAccessibleObjectFromEvent(int hwnd, int dwId, int dwChildId) {
        if (currentFactory != null) {
            return currentFactory.getAccessibleObjectFromEvent(hwnd, dwId, dwChildId);
        }
        return null;
    }

    public static IAccessibleEventMonitor getAccessibleEventMonitor() {
        if (currentFactory != null) {
            return currentFactory.getAccessibleEventMonitor();
        }
        return null;
    }

    public static AccessibleObject getAccessibleObjectFromVariant(Variant varDispatch) {
        if (varDispatch != null && 9 == varDispatch.getType()) {
            return new InternalAccessibleObject(null, varDispatch);
        }
        return null;
    }

    public static boolean setActiveFactory(String id) {
        if (id.equals(currentFactoryId)) {
            return false;
        }
        AccessibleFactoryEntry entry = factoryEntries.get(id);
        if (entry != null) {
            currentFactoryId = id;
            currentFactory = entry.accessibleObjectFactory;
            return true;
        }
        return false;
    }

    public static AccessibleFactoryEntry getFactoryEntry(String id) {
        return factoryEntries.get(id);
    }

    public static String[] getFactoryIds() {
        return factoryEntries.keySet().toArray(new String[factoryEntries.size()]);
    }

    public static void addFactoryEntry(String id, AccessibleFactoryEntry factory) {
        factoryEntries.put(id, factory);
    }
}

