/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.util;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class AlphaToMaskOp
implements BufferedImageOp {
    private final boolean inverted;

    public AlphaToMaskOp(boolean inverted) {
        this.inverted = inverted;
    }

    public AlphaToMaskOp() {
        this(false);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        ColorModel cm = src.getColorModel();
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, cm);
        } else {
            if (dest.getWidth() != src.getWidth() || dest.getHeight() != src.getHeight()) {
                throw new IllegalArgumentException("Source and destination images have different dimensions.");
            }
            if (dest.getColorModel() != cm) {
                throw new IllegalArgumentException("Color models don't match.");
            }
        }
        if (cm.hasAlpha()) {
            WritableRaster srcRaster = src.getRaster();
            WritableRaster destRaster = dest.getRaster();
            int y = 0;
            while (y < srcRaster.getHeight()) {
                int x = 0;
                while (x < srcRaster.getWidth()) {
                    int argb = cm.getRGB(srcRaster.getDataElements(x, y, null));
                    int alpha = argb >>> 24;
                    argb = alpha >= 127 && !this.isInverted() || alpha < 127 && this.isInverted() ? (argb |= 0xFF000000) : (argb &= 0xFFFFFF);
                    destRaster.setDataElements(x, y, cm.getDataElements(argb, null));
                    ++x;
                }
                ++y;
            }
        }
        return dest;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(src.getRaster().getBounds());
        return bounds;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        WritableRaster raster = destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        boolean isRasterPremultiplied = destCM.isAlphaPremultiplied();
        Hashtable<String, Object> properties = null;
        if (src.getPropertyNames() != null) {
            properties = new Hashtable<String, Object>();
            String[] stringArray = src.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                properties.put(key, src.getProperty(key));
                ++n2;
            }
        }
        BufferedImage bimage = new BufferedImage(destCM, raster, isRasterPremultiplied, properties);
        src.copyData(raster);
        return bimage;
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

