/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.images;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.clipboard.ImageSupplier;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public class ImageFactory<T extends ScrollableChart> {
    private T t;
    private ImageSupplier imageSupplier;
    private Display display;

    public ImageFactory(Class<T> clazz, int width, int height) throws InstantiationException, IllegalAccessException {
        try {
            this.t = (ScrollableChart)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.imageSupplier = new ImageSupplier();
            this.display = this.t.getBaseChart().getDisplay();
            if (this.display != null) {
                width = width > this.display.getBounds().width ? this.display.getBounds().width : width;
                height = height > this.display.getBounds().height ? this.display.getBounds().height : height;
                this.t.getShell().setSize(width, height);
            }
        }
        catch (Exception e) {
            throw new InstantiationException();
        }
    }

    public T getChart() {
        return this.t;
    }

    public void closeShell() {
        this.t.getShell().close();
    }

    public void saveImage(String fileName, int format) {
        this.t.getShell().open();
        while (!this.t.getShell().isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
            ImageData imageData = this.imageSupplier.getImageData(this.t.getBaseChart());
            this.imageSupplier.saveImage(imageData, fileName, format);
            return;
        }
    }
}

