/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.export;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.images.ImageSupplier;
import org.eclipse.swtchart.extensions.menu.export.AbstractSeriesExportHandler;
import org.eclipse.swtchart.extensions.menu.export.ISeriesExportConverter;

public class PrinterExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    public static final String NAME = "Print";
    private static final String TITLE = "Save Selection";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void execute(Shell shell, ScrollableChart scrollableChart) {
        PrintDialog dialog = new PrintDialog(shell);
        PrinterData printerData = dialog.open();
        if (printerData != null) {
            Printer printer = new Printer(printerData);
            if (printer.startJob("PrinterExport")) {
                GC gc = new GC((Drawable)printer);
                printer.startPage();
                Rectangle trim = printer.computeTrim(0, 0, 0, 0);
                Rectangle clientArea = printer.getClientArea();
                ImageSupplier imageSupplier = new ImageSupplier();
                ImageData imageData = imageSupplier.getImageData(scrollableChart.getBaseChart());
                Image image = new Image((Device)printer, imageData);
                int srcWidth = imageData.width;
                int srcHeight = imageData.height;
                if (srcWidth > 0) {
                    double scalingFactor = (double)srcHeight / ((double)srcWidth * 1.0);
                    int destWidth = clientArea.width + trim.x;
                    int destHeight = (int)((double)clientArea.width * scalingFactor) + trim.y;
                    gc.drawImage(image, 0, 0, srcWidth, srcHeight, -trim.x, -trim.y, destWidth, destHeight);
                }
                image.dispose();
                gc.dispose();
                printer.endPage();
                printer.endJob();
                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)"The data has been exported successully.");
            }
            printer.dispose();
        }
    }
}

